<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\User;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use App\Helpers\PublicHelper;

class LoginController extends Controller
{
    public function login(Request $request)
    {

        $credentials = $request->only('email', 'password');

        //Log::info('login: ', ['credentials' => $credentials['email'], $credentials['password']]);

        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);


        $user = User::where('ml', $credentials['email'])->first();

        //Log::info('user: ', ['user' => $user->psw]);

        if (!$user || $user->psw !== $credentials['password']) {
            return response()->json([
                'success' => false,
                'message' => __('Invalid login credentials!')
            ], 401)->header('Content-Type', 'application/json; charset=utf-8');
        }


        $token = $this->createJwtToken($user);

        return response()->json([
            'success' => true,
            'message' => __('Login successful!'),
            'token' => $token,
        ])->cookie(config('jwt.public_key'), $token, 1440, '/', null, false, true);

        // 43200 dakika = 30 gün, HttpOnly + Secure
    }

    public function createJwtToken(User $user)
    {
        $owenerId = $user->mid;
        if($user->typ == 3){ //admin
            $owenerId = $user->id;
        }

        $user = [
            'id' => $user->id,
            'sid' => $user->sid,
            'mid' => $owenerId,
            'typ' => $user->typ,
            'nm' => $user->nm,
            'permissions' => $user->getDirectPermissionsArray(), // Add module permissions to JWT for menu
        ];

        // Get system settings from database
        $systemSettings = \App\Models\GeneralSetting::getSystemSettings($user['mid'], $user['sid']);

        //Log::info("systemSettings", [$systemSettings]);
        
        // Extract system configuration values
        $settingsArray = $systemSettings->pluck('typed_value', 'setting_key');

        $locale = $settingsArray['language'] ?? 'tr';
        $timezone = $settingsArray['timezone'] ?? 'Europe/Istanbul';
        $dateFormat = $settingsArray['date_format'] ?? 'd.m.y';
        $timeFormat = $settingsArray['time_format'] ?? 'H:i';
        $currency = $settingsArray['currency'] ?? 'TRY';
        $speedUnit = $settingsArray['speed_unit'] ?? 'km/h';
        $weightUnit = $settingsArray['weight_unit'] ?? 'kg';
        $liquidUnit = $settingsArray['liquid_unit'] ?? 'lt';
        $lengthUnit = $settingsArray['length_unit'] ?? 'mt';

        // JWT payload oluşturuluyor
        // LOOK: GeneralSettingController.php private function refreshJwtToken(Request $request, $response)
        $payload = [
            'userId'   => $user['id'],
            'storeId'  => $user['sid'],
            'owenerId' => $user['mid'],
            'userType' => $user['typ'],
            'userName' => $user['nm'],
            'permissions' => $user['permissions'], // Add direct permissions to payload
            'locale'   => $locale,
            'timezone' => $timezone,
            'dateFormat' => $dateFormat,
            'timeFormat' => $timeFormat,
            'currency' => $currency,
            'speedUnit' => $speedUnit,
            'weightUnit' => $weightUnit,
            'liquidUnit' => $liquidUnit,
            'lengthUnit' => $lengthUnit,
            'exp'      => time() + (60 * 60 * 24 * 30), // 30 gün
        ];

        //Log::info("payload", [$payload]);

        $token = JWT::encode($payload, config('jwt.secret'), 'HS256');

        return $token;
    }

    public function logout(Request $request)
    {
        return redirect('/')
            ->withCookies([cookie(config('jwt.public_key'), '', -1)]) // Cookie'yi sil
            ->with('success', __('Logout successful!'));
    }
}