<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Alarm extends Model
{
    protected $table = 'vts_device_alarms';
    protected $primaryKey = 'id';
    public $timestamps = false;

    protected $fillable = [
        'mid',
        'did',
        'aid',
        'sts',
        'sid',
        'settings_json',
        'send_datetime',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    protected $casts = [
        'mid' => 'integer',
        'aid' => 'integer',
        'sts' => 'integer',
        'sid' => 'integer',
        'send_datetime' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'settings_json' => 'array',
    ];
}