<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class DeviceLog extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'vts_device_logs';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
            'ip',
            'did',
            'latitude',
            'longitude',
            'coord',
            'notification_sent',
            'log_data_json', // json
            'log_datetime',
            'dt'
            ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'latitude' => 'decimal:6',
        'longitude' => 'decimal:6',
        'log_datetime' => 'datetime',
        'dt' => 'datetime',
        'log_data_json' => 'array',
    ];

    /**
     * Get the device associated with this log.
     */
    public function device()
    {
        return $this->belongsTo(Device::class, 'did', 'did');
    }

}
