<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Region extends Model
{
    protected $table = 'vts_regions';

    protected $fillable = [
        'mid',
        'nm',
        'ord',
        'pcnt',
        'sts',
        'ply',
        'poly',
        'dt',
        'active',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    protected $casts = [
        'mid' => 'integer',
        'ord' => 'integer',
        'pcnt' => 'integer',
        'sts' => 'integer',
        'active' => 'integer',
        'dt' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the devices associated with this region.
     */
    public function devices()
    {
        return $this->hasMany(RegionDeviceMatch::class, 'pid', 'id');
    }

    /**
     * Get the member/user associated with this region.
     */
    public function member()
    {
        return $this->belongsTo(User::class, 'mid', 'id');
    }
}
