<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPermission extends Model
{
    use HasFactory;

    protected $table = 'vts_user_permissions';

    protected $fillable = [
        'user_id',
        'permission_name',
        'can_access',
        'can_view',
        'can_edit',
        'can_delete'
    ];

    protected $casts = [
        'can_access' => 'boolean',
        'can_view' => 'boolean',
        'can_edit' => 'boolean',
        'can_delete' => 'boolean'
    ];

    /**
     * Get the user that owns this permission
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope to filter by permission name
     */
    public function scopeByName($query, $permissionName)
    {
        return $query->where('permission_name', $permissionName);
    }

    /**
     * Scope to filter by access level
     */
    public function scopeCanAccess($query)
    {
        return $query->where('can_access', true);
    }

    public function scopeCanView($query)
    {
        return $query->where('can_view', true);
    }

    public function scopeCanEdit($query)
    {
        return $query->where('can_edit', true);
    }

    public function scopeCanDelete($query)
    {
        return $query->where('can_delete', true);
    }
}
