<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\GeneralSetting;

class DefaultSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Default Fuel Settings
        $fuelSettings = [
            [
                'key' => 'fuel_price_diesel',
                'value' => '25.50',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'Default diesel fuel price per liter'
            ],
            [
                'key' => 'fuel_price_gasoline',
                'value' => '28.75',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'Default gasoline fuel price per liter'
            ],
            [
                'key' => 'fuel_price_lpg',
                'value' => '15.25',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'Default LPG fuel price per liter'
            ],

        ];

        // Default Maintenance Settings
        $maintenanceSettings = [
            [
                'key' => 'maintenance_reminder_days',
                'value' => '30',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Default maintenance reminder days'
            ],
            [
                'key' => 'oil_change_km',
                'value' => '10000',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Default oil change interval in kilometers'
            ],
            [
                'key' => 'tire_change_km',
                'value' => '50000',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Default tire change interval in kilometers'
            ],
            [
                'key' => 'maintenance_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'maintenance',
                'description' => 'Default maintenance reminders enabled'
            ]
        ];

        // Default Alert Settings
        $alertSettings = [
            [
                'key' => 'speed_limit_default',
                'value' => '90',
                'type' => 'number',
                'category' => 'alerts',
                'description' => 'Default speed limit in km/h'
            ],
            [
                'key' => 'geofence_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Default geofence alerts enabled'
            ],
            [
                'key' => 'maintenance_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Default maintenance alerts enabled'
            ],
            [
                'key' => 'fuel_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Default fuel level alerts enabled'
            ],
            [
                'key' => 'alert_email_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Default email alerts enabled'
            ],
            [
                'key' => 'alert_sms_enabled',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Default SMS alerts disabled'
            ]
        ];

        // Default System Settings
        $systemSettings = [
            [
                'key' => 'timezone',
                'value' => 'Europe/Istanbul',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default timezone'
            ],
            [
                'key' => 'language',
                'value' => 'tr',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default language'
            ],
            [
                'key' => 'date_format',
                'value' => 'd.m.Y',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default date format'
            ],
            [
                'key' => 'time_format',
                'value' => 'H:i',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default time format'
            ],
            [
                'key' => 'auto_backup_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'system',
                'description' => 'Default automatic backup enabled'
            ],
            [
                'key' => 'backup_frequency',
                'value' => 'daily',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default backup frequency'
            ],
            [
                'key' => 'currency',
                'value' => 'TRY',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default system currency'
            ],
            [
                'key' => 'weight_unit',
                'value' => 'kg',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default weight unit'
            ],
            [
                'key' => 'liquid_unit',
                'value' => 'lt',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default liquid unit'
            ],
            [
                'key' => 'length_unit',
                'value' => 'mt',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Default length unit'
            ]
        ];

        // Combine all settings
        $allSettings = array_merge($fuelSettings, $maintenanceSettings, $alertSettings, $systemSettings);

        // Create default settings with mid=0 and store_id=0
        foreach ($allSettings as $setting) {
            GeneralSetting::updateOrCreate(
                [
                    'mid' => 0,
                    'store_id' => 0,
                    'setting_key' => $setting['key']
                ],
                [
                    'setting_value' => $setting['value'],
                    'setting_type' => $setting['type'],
                    'category' => $setting['category'],
                    'description' => $setting['description'],
                    'is_active' => true
                ]
            );
        }

        $this->command->info('Default settings seeded successfully!');
    }
} 