<?php
/**
 * Step 2: Database Configuration
 */

$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['test_connection'])) {
    $dbHost = $_POST['db_host'] ?? '';
    $dbPort = $_POST['db_port'] ?? '3306';
    $dbName = $_POST['db_name'] ?? '';
    $dbUser = $_POST['db_user'] ?? '';
    $dbPass = $_POST['db_pass'] ?? '';
    
    // Test connection
    try {
        $dsn = "mysql:host={$dbHost};port={$dbPort}";
        $pdo = new PDO($dsn, $dbUser, $dbPass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Check if database exists
        $stmt = $pdo->query("SHOW DATABASES LIKE '{$dbName}'");
        $dbExists = $stmt->rowCount() > 0;
        
        if (!$dbExists) {
            // Create database
            $pdo->exec("CREATE DATABASE `{$dbName}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        }
        
        // Save to session
        $_SESSION['install']['db_config'] = [
            'host' => $dbHost,
            'port' => $dbPort,
            'database' => $dbName,
            'username' => $dbUser,
            'password' => $dbPass
        ];
        $_SESSION['install']['completed_steps'][2] = true;
        
        // Redirect to next step after successful connection
        header('Location: ?step=3');
        exit;
        
    } catch (PDOException $e) {
        $error = "Connection failed: " . $e->getMessage();
    }
}

// Get saved values
$dbConfig = $_SESSION['install']['db_config'] ?? [];
?>

<h2 class="card-title mb-4">
    <i class="ti ti-database me-2"></i> Database Configuration
</h2>

<p class="text-muted mb-4">
    Enter your database connection details. The installer will create the database if it doesn't exist.
</p>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        <h4 class="alert-title"><i class="ti ti-alert-circle"></i> Connection Error</h4>
        <div class="text-muted"><?= htmlspecialchars($error) ?></div>
    </div>
<?php endif; ?>


<form method="POST" id="dbForm">
    <div class="mb-3">
        <label class="form-label required">Database Host</label>
        <input type="text" name="db_host" class="form-control" 
               value="<?= htmlspecialchars($dbConfig['host'] ?? '127.0.0.1') ?>" 
               required>
        <small class="form-hint">Usually localhost or 127.0.0.1</small>
    </div>

    <div class="mb-3">
        <label class="form-label">Database Port</label>
        <input type="text" name="db_port" class="form-control" 
               value="<?= htmlspecialchars($dbConfig['port'] ?? '3306') ?>">
        <small class="form-hint">Default MySQL port is 3306</small>
    </div>

    <div class="mb-3">
        <label class="form-label required">Database Name</label>
        <input type="text" name="db_name" class="form-control" 
               value="<?= htmlspecialchars($dbConfig['database'] ?? 'fleet_tracker') ?>" 
               required>
        <small class="form-hint">Will be created if it doesn't exist</small>
    </div>

    <div class="mb-3">
        <label class="form-label required">Database Username</label>
        <input type="text" name="db_user" class="form-control" 
               value="<?= htmlspecialchars($dbConfig['username'] ?? 'root') ?>" 
               required>
    </div>

    <div class="mb-3">
        <label class="form-label">Database Password</label>
        <input type="password" name="db_pass" class="form-control" 
               value="<?= htmlspecialchars($dbConfig['password'] ?? '') ?>">
        <small class="form-hint">Leave empty if no password</small>
    </div>

    <div class="d-flex justify-content-between mt-4">
        <a href="?step=1" class="btn">
            <i class="ti ti-arrow-left me-2"></i> Back
        </a>
        <div>
            <button type="submit" name="test_connection" class="btn btn-secondary me-2">
                <i class="ti ti-plug me-2"></i> Test Connection
            </button>
            <a href="?step=3" class="btn btn-primary <?= empty($_SESSION['install']['completed_steps'][2]) ? 'disabled' : '' ?>">
                Next: Create Admin
                <i class="ti ti-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</form>

