@php
    $buttonClasses = ['btn'];
    
    // Type class
    if ($outline) {
        $buttonClasses[] = 'btn-outline-' . $type;
    } else {
        $buttonClasses[] = 'btn-' . $type;
    }
    
    // Size class
    if ($size === 'sm') {
        $buttonClasses[] = 'btn-sm';
    } elseif ($size === 'lg') {
        $buttonClasses[] = 'btn-lg';
    }
    
    // Custom class
    if ($class) {
        $buttonClasses[] = $class;
    }
    
    $buttonClass = implode(' ', $buttonClasses);
    
    // Icon HTML
    $iconHtml = '';
    if ($icon) {
        $iconClass = strpos($icon, ' ') !== false ? $icon : 'ti ti-' . $icon;
        $iconHtml = '<i class="' . $iconClass . '"></i>';
    }
@endphp

@if($href)
    <a href="{{ $href }}" 
       @if($target) target="{{ $target }}" @endif
       @if($onclick) onclick="{{ $onclick }}" @endif
       @if($id) id="{{ $id }}" @endif
       class="{{ $buttonClass }}"
       @if($disabled) disabled @endif>
        @if($icon && $iconPosition === 'left')
            {!! $iconHtml !!}
        @endif
        {{ $slot }}
        @if($icon && $iconPosition === 'right')
            {!! $iconHtml !!}
        @endif
    </a>
@else
    <button type="button"
            @if($onclick) onclick="{{ $onclick }}" @endif
            @if($id) id="{{ $id }}" @endif
            class="{{ $buttonClass }}"
            @if($disabled) disabled @endif>
        @if($icon && $iconPosition === 'left')
            {!! $iconHtml !!}
        @endif
        {{ $slot }}
        @if($icon && $iconPosition === 'right')
            {!! $iconHtml !!}
        @endif
    </button>
@endif