<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme-primary="orange" data-bs-theme="dark">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
  <meta http-equiv="X-UA-Compatible" content="ie=edge" />
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>@yield('title') | {{ config('app.name') }}</title>
  <script>
     window.translations = @json(Lang::get("*"));
  </script>
  <!-- ===== CSS FILES ===== -->
  <!-- Tabler Core CSS -->
  <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/dist/css/tabler.min.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.assets')) }}/dist/css/tabler-themes.min.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.assets')) }}/dist/css/tabler-vendors.min.css?{{config('app.version')}}" />
  <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/dist/css/demo.min.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.assets')) }}/dist/libs/nouislider/dist/nouislider.min.css?{{config('app.version')}}" />

  <!-- Third Party CSS Libraries -->
  <link rel="stylesheet" href="{{ asset(config('app.js_lib')) }}/toastr/toastr.min.css?{{config('app.version')}}">
  <link rel="stylesheet" href="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/css/tabulator.min.css?{{config('app.version')}}">
  <!-- <link rel="stylesheet" href="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/css/tabulator_midnight.min.css?{{config('app.version')}}"> -->
  <link rel="stylesheet" href="{{ asset(config('app.js_lib')) }}/select2@4.1.0/select2.min.css?{{config('app.version')}}" />

  <!-- Font Icons -->
  <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/dist/fonts-tabler/tabler-icons.min.css">
  <link rel="stylesheet"
    href="{{ asset(config('app.assets')) }}/icon/fontawesome-free-6.7.2-web/css/all.min.css?{{config('app.version')}}" />

  <!-- Leaflet CSS -->
  <link rel="stylesheet" href="{{ asset(config('app.leaflet_lib')) }}/leaflet.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.leaflet_lib')) }}/plugin/markercluster_1.4.1/MarkerCluster.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.leaflet_lib')) }}/plugin/markercluster_1.4.1/MarkerCluster.Default.css?{{config('app.version')}}" />
  <link rel="stylesheet"
    href="{{ asset(config('app.leaflet_lib')) }}/plugin/leaflet.draw/leaflet.draw.css?{{config('app.version')}}" />

  <!-- Custom CSS -->
  <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/css/custom.css?{{config('app.version')}}">

  <!-- ===== FAVICON FILES ===== -->
  <link rel="shortcut icon" href="{{ asset(config('app.assets')) }}/img/browser/favicon.ico" type="image/x-icon">
  <link rel="icon" href="{{ asset(config('app.assets')) }}/img/browser/favicon.ico" type="image/x-icon">
  <link rel="apple-touch-icon" sizes="57x57" href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-57x57.png">
  <link rel="apple-touch-icon" sizes="60x60" href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-60x60.png">
  <link rel="apple-touch-icon" sizes="72x72" href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-72x72.png">
  <link rel="apple-touch-icon" sizes="76x76" href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-76x76.png">
  <link rel="apple-touch-icon" sizes="114x114"
    href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-114x114.png">
  <link rel="apple-touch-icon" sizes="120x120"
    href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-120x120.png">
  <link rel="apple-touch-icon" sizes="144x144"
    href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-144x144.png">
  <link rel="apple-touch-icon" sizes="152x152"
    href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-152x152.png">
  <link rel="apple-touch-icon" sizes="180x180"
    href="{{ asset(config('app.assets')) }}/img/browser/apple-icon-180x180.png">
  <link rel="icon" type="image/png" sizes="192x192"
    href="{{ asset(config('app.assets')) }}/img/browser/android-icon-192x192.png">
  <link rel="icon" type="image/png" sizes="32x32"
    href="{{ asset(config('app.assets')) }}/img/browser/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="96x96"
    href="{{ asset(config('app.assets')) }}/img/browser/favicon-96x96.png">
  <link rel="icon" type="image/png" sizes="16x16"
    href="{{ asset(config('app.assets')) }}/img/browser/favicon-16x16.png">
  <link rel="manifest" href="{{ asset(config('app.assets')) }}/img/browser/manifest.json">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="msapplication-TileImage" content="{{ asset(config('app.assets')) }}/img/browser/ms-icon-144x144.png">
  <meta name="theme-color" content="#ffffff">

  @yield('styles')
</head>

<body class="layout-fluid">
  <script src="{{ asset(config('app.assets')) }}/dist/js/demo-theme.min.js?{{config('app.version')}}"></script>

  <div id="loading">
    <img id="page-loading" src="{{ asset(config('app.assets')) }}/img/infinite-spinner.svg" />
  </div>

  <div class="page">
    @include('partials.menu')

    <div class="page-wrapper">
      @yield('content')

      @include('partials.footer')
    </div>
  </div>
  @include('partials.theme-settings')
  <!-- ===== JAVASCRIPT FILES ===== -->
  <!-- Core Libraries -->
  <script src="{{ asset(config('app.js_lib')) }}/jquery-3.7.1.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.assets')) }}/js/common.js?{{config('app.version')}}"></script>
  
  <!-- Tabler Core JS -->
  <script src="{{ asset(config('app.assets')) }}/dist/js/tabler.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.assets')) }}/dist/js/demo.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.assets')) }}/dist/js/tabler-theme.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.assets')) }}/dist/libs/nouislider/dist/nouislider.min.js?{{config('app.version')}}">
  </script>

  <!-- Third Party JS Libraries -->
  <script src="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/js/tabulator.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/js/ext/xlsx.full.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/js/ext/jspdf.umd.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.js_lib')) }}/tabulator-master/dist/js/ext/jspdf.plugin.autotable.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.js_lib')) }}/select2@4.1.0/select2.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.js_lib')) }}/toastr/toastr.min.js?{{config('app.version')}}"></script>

  <!-- Chart Libraries -->
  <script src="{{ asset(config('app.assets')) }}/dist/libs/apexcharts/dist/apexcharts.min.js?{{config('app.version')}}"></script>

  <!-- Leaflet JS -->
  <script src="{{ asset(config('app.leaflet_lib')) }}/leaflet.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.leaflet_lib')) }}/plugin/markercluster_1.4.1/leaflet.markercluster.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.leaflet_lib')) }}/plugin/polylinedecorator_1.6.0/leaflet.polylineDecorator.min.js?{{config('app.version')}}"></script>
  <script src="{{ asset(config('app.leaflet_lib')) }}/plugin/leaflet.draw/leaflet.draw.js?{{config('app.version')}}">
  </script>

  <!-- Custom JS -->
  <script src="{{ asset(config('app.js_custom')) }}/map.js?{{config('app.version')}}"></script>


  @yield('scripts')

</body>

</html>