@php
$alarm_form_id = 301; // Muayene alarm form ID
$inspection = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($inspection && isset($inspection['settings_json']) && $inspection['settings_json']){
// JSON string ise decode et, array ise direkt kullan
if(is_string($inspection['settings_json'])){
$j = json_decode($inspection['settings_json'], true) ?: [];
} else {
$j = $inspection['settings_json'];
}
}
@endphp
<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">
    {{-- Alarm durumu seçimi --}}
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{ $alarm_form_id }}" value="1" class="form-selectgroup-input" {{
                isset($inspection['status_id']) && $inspection['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                {{ __('Alarm Open') }}
            </span>
        </label>
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{ $alarm_form_id }}" value="0" class="form-selectgroup-input" {{
                !isset($inspection['status_id']) || !$inspection['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                {{ __('Alarm Closed') }}
            </span>
        </label>
    </div>

    {{-- Muayene tarihi seçimi --}}
    <div class="mb-3">
        <label class="form-label">{{ __('Inspection Date') }}</label>
        <div class="row g-2">
            <div class="col-12">
                <input type="date" name="inspection_date" class="form-control"
                    value="{{ $j['inspection_date'] ?? '' }}">
            </div>
        </div>
    </div>
    {{-- Bildirim Gönderim durumu seçimi --}}
    {{-- <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="send_status_id_{{ $alarm_form_id }}" value="1" class="form-selectgroup-input" {{
                isset($inspection['send_status_id']) && $inspection['send_status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                {{ __('Send Notification') }}
            </span>
        </label>
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="send_status_id_{{ $alarm_form_id }}" value="0" class="form-selectgroup-input" {{
                !isset($inspection['send_status_id']) || !$inspection['send_status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                {{ __('Notification Closed') }}
            </span>
        </label>
    </div> --}}
    {{-- Alarm gönderilecek kişiler --}}
    {{-- <fieldset class="form-fieldset">
        <div class="mb-3">
            <h3>{{ __('To whom will alarms be sent?') }}</h3>
        </div>
        <div class="mb-3">
            <label class="form-label">{{ __('Cell Phone') }}</label>
            <input type="text" name="phone" class="form-control" data-mask="(000) 000-0000" data-mask-visible="true"
                placeholder="(000) 000-0000" autocomplete="off" value="{{ $j['phone'] ?? '' }}">
        </div>
        <div class="mb-3">
            <label class="form-label">{{ __('E-mail') }}</label>
            <input type="email" name="email" class="form-control" aria-describedby="emailHelp"
                placeholder="{{ __('Enter email') }}" value="{{ $j['email'] ?? '' }}">
        </div>
    </fieldset> --}}

    <div class="d-flex justify-content-end">
        <button type="button" class="btn btn-primary" onclick="saveAlarmSettings({{ $alarm_form_id }})" id="saveAllBtn">
            <i class="icon ti ti-device-floppy me-1"></i>
            {{ __('Save All Settings') }}
        </button>
    </div>
</form>
{{--
Note:
<script>
    vehicle-settings.blade.php
    function saveAlarmSettings(alarm_form_id) {
</script>
--}}