@extends('layouts.app')

@section('title', __('Regions & Polygons') )

@section('content')

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="/dashboard" class="text-muted">{{ __('Dashboard') }}</a> / {{ __('Geographic Management') }}
                </div>
                <h2 class="page-title">
                    <i class="ti ti-map-pin me-2 text-primary"></i>
                    {{ __('Regions & Polygons') }}
                </h2>
                <div class="page-subtitle">
                    <p class="text-muted mb-0">
                        {{ __('Regions description') }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <!-- Quick Stats -->
        <div class="row row-deck row-cards mb-4">
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">{{ __('Total Regions') }}</div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold" id="totalRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">{{ __('Active Regions') }}</div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-success" id="activeRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader">{{ __('Passive Regions') }}</div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-secondary" id="passiveRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Regions List & Map -->
        <div class="row row-deck row-cards">
            <!-- Left Panel - Regions List -->
            <div class="col-5">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('Regions List') }}</h3>
                        <div class="card-actions">
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <div id="regionsList"></div>
                            <div id="regionForm"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Right Panel - Map & Polygon Editor -->
            <div class="col-7">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title" id="mapTitle">
                            <i class="fas fa-map text-blue"></i>
                            {{ __('Select a region to edit polygons') }}
                        </h3>
                        <div class="card-actions" id="mapActions" style="display: none;">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-primary" id="drawPolygon">
                                    <i class="fas fa-draw-polygon"></i>
                                    {{ __('Draw Polygon') }}
                                </button>
                                <button type="button" class="btn btn-sm btn-success" id="savePolygons" disabled>
                                    <i class="fas fa-save"></i>
                                    {{ __('Save Changes') }}
                                </button>
                                <button type="button" class="btn btn-sm btn-danger" id="clearPolygons">
                                    <i class="fas fa-trash"></i>
                                    {{ __('Clear All') }}
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div id="map1"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    #map1 {
        height: calc(100vh - 375px);
        width: 100%;
    }
</style>
@endsection

@section('scripts')
    <script src="{{ asset(config('app.js_page')) }}/regions.js"></script>
@endsection