@php
$vehicle = $vehicle ?? [];
@endphp

@extends('layouts.app')

@section('title', __('Settings') )

@section('content')
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    {{ __('Settings') }}
                </div>
                <h2 class="page-title">
                    {{ $vehicle['name'] ?? __('Unknown') }}
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row row-deck row-cards">
            {{-- Settings --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-settings-check"></i>
                            {{ __('Settings') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.general')
                    </div>
                </div>
            </div>
            {{-- Categories --}}
            <div class="col-sm-6 col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-category-plus"></i>
                            {{ __('Categories') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.category', ['categories' => $categories])

                    </div>
                </div>
            </div>
            {{-- Vehicle Inspection --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-calendar-exclamation"></i>
                            {{ __('Vehicle Inspection') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.inspection', ['inspection' => $alarms])
                    </div>
                </div>
            </div>
            {{-- Engine Blockage --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-engine"></i>
                            {{ __('Engine Blockage') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.engine_block')
                    </div>
                </div>
            </div>
            {{-- Vehicle Being Towed --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-parking-off"></i>
                            {{ __('Vehicle Being Towed') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.towed')
                    </div>
                </div>
            </div>
            {{-- High Speed ​​Alarm --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-brand-speedtest"></i>
                            {{ __('High Speed ​​Alarm') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.high_speed', ['alarms' => $alarms])
                    </div>
                </div>
            </div>
            {{-- Acceleration/Deceleration Alarm --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-arrow-iteration"></i>
                            {{ __('Acceleration/Deceleration Alarm') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.acceleration_deceleration')
                    </div>
                </div>
            </div>
            {{-- Mileage Maintenance --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-road"></i>
                            {{ __('Mileage Maintenance') }}
                        </h4>
                    </div>
                    <div class="card-body">
                        @include('partials.forms.settings.mileage_maintenance')
                    </div>
                </div>
            </div>
            {{-- After-hours use --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-clock-shield"></i>
                            {{ __('After-hours use') }}
                        </h4>
                    </div>
                    <div class="">
                        @include('partials.forms.settings.after_hours')
                    </div>
                </div>
            </div>
            {{-- Regions --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-polygon"></i>
                            {{ __('Regions') }}
                        </h4>
                        <div class="card-actions">
                            <a href="/regions" class="btn btn-primary">
                                <i class="icon vertical-center ti ti-settings-check"></i>
                                {{ __('Add') }} / {{ __('Edit') }}
                            </a>
                        </div>
                    </div>
                    @include('partials.forms.settings.region', ['regions' => $regions])
                </div>
            </div>
            {{-- Places --}}
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-map-pin"></i>
                            {{ __('Places') }}
                        </h4>
                        <div class="card-actions">
                            <a href="/places" class="btn btn-primary">
                                <i class="icon vertical-center ti ti-settings-check"></i>
                                {{ __('Add') }} / {{ __('Edit') }}
                            </a>
                        </div>
                    </div>
                    @include('partials.forms.settings.places', ['places' => $places])
                </div>
            </div>
            {{--- End --}}
        </div>
    </div>
</div>
<input type="hidden" id="device_id" value="{{ $vehicle['did'] ?? '' }}" />
@endsection

@section('styles')
@endsection

{{--
function saveAlarmSettings(alarm_form_id)
Alarm Form Ids:
+ 301: Inspection
+ 302: Engine Blockage
+ 303: Vehicle Being Towed
+ 304: High Speed ​​Alarm
+ 305: Acceleration/Deceleration Alarm
+ 306: Mileage Maintenance
+ 307: After-hours use
--}}

@section('scripts')
<script>
    var menuModel = {
        actives : ["report-vehicles"],
        shows: []
    };
    menuSets(menuModel);
    
    onAppReady(function() {
        //init partials scripts
        initVehicleSettingsGeneral();
        initVehicleSettingsEngineBlock();
        initCategories();
    });

    // disable form submit
    $(".alarm-form").on("submit", function(e) {
        e.preventDefault();
    });

    function saveAlarmSettings(alarm_form_id) {
        setTimeout(() => {
            
            // Prepare data and encode with Base64Helper
            // get form data by form id
            const formData = new FormData(document.getElementById("alarmForm_" + alarm_form_id));
            // add device_id to formData
            formData.append("device_id", $("#device_id").val());
            // add alarm_form_id to formData
            formData.append("alarm_form_id", alarm_form_id);
            // formData to Base64Helper.encode
            const postData = Base64Helper.encode(Object.fromEntries(formData.entries()));
            
            http.post({
                url: "/alarm-set-device",
                data: {
                    data: postData
                }
            })
            .then(function(response) {
                if (response.success) {
                    showNotification("success", __(response.message));
                } else {
                    showNotification("error", __(response.message));
                }
            })
            .catch(function(error) {
                console.error("Update error:", error);
                showNotification("error", "{{ __('Error updating') }}");
            });

        }, 100);
    }

</script>
@endsection