<?php
    $modalClass = 'modal fade';
    $dialogClass = 'modal-dialog';
    $contentClass = 'modal-content';
    $headerClass = 'modal-header';
    $bodyClass = 'modal-body';
    $footerClass = 'modal-footer';
    
    // Size classes
    switch ($size) {
        case 'sm':
            $dialogClass .= ' modal-sm';
            break;
        case 'lg':
            $dialogClass .= ' modal-lg';
            break;
        case 'xl':
            $dialogClass .= ' modal-xl';
            break;
        case 'fullscreen':
            $dialogClass .= ' modal-fullscreen';
            break;
    }
    
    // Centered
    if ($centered) {
        $dialogClass .= ' modal-dialog-centered';
    }
    
    // Scrollable
    if ($scrollable) {
        $dialogClass .= ' modal-dialog-scrollable';
    }
    
    // Custom classes
    if ($class) {
        $modalClass .= ' ' . $class;
    }
    if ($headerClass) {
        $headerClass .= ' ' . $headerClass;
    }
    if ($bodyClass) {
        $bodyClass .= ' ' . $bodyClass;
    }
    if ($footerClass) {
        $footerClass .= ' ' . $footerClass;
    }
    
    // Backdrop and keyboard attributes
    $dataAttributes = '';
    if (!$backdrop) {
        $dataAttributes .= ' data-bs-backdrop="static"';
    }
    if (!$keyboard) {
        $dataAttributes .= ' data-bs-keyboard="false"';
    }
?>

<div class="<?php echo e($modalClass); ?>" id="<?php echo e($id); ?>" tabindex="-1" aria-labelledby="<?php echo e($id); ?>-title" aria-hidden="true"<?php echo e($dataAttributes); ?>>
    <div class="<?php echo e($dialogClass); ?>">
        <div class="<?php echo e($contentClass); ?>">
            <?php if($title || $showCloseButton): ?>
                <div class="<?php echo e($headerClass); ?>">
                    <?php if($title): ?>
                        <h5 class="modal-title" id="<?php echo e($id); ?>-title">
                            <?php echo e($title); ?>

                        </h5>
                    <?php endif; ?>
                    <?php if($showCloseButton): ?>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            
            <div class="<?php echo e($bodyClass); ?>">
                <?php echo e($slot); ?>

            </div>
            
            <?php if($footer || $slot->has('footer')): ?>
                <div class="<?php echo e($footerClass); ?>">
                    <?php if($slot->has('footer')): ?>
                        <?php echo e($footer); ?>

                    <?php else: ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <?php echo e($closeButtonText); ?>

                        </button>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\components\modal.blade.php ENDPATH**/ ?>