<?php $__env->startSection('title', __('Vehicle Map') ); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Vehicle Monitoring')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Live Vehicle Tracking')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <button class="btn btn-primary" id="refresh-btn">
                            <i class="ti ti-refresh me-1"></i>
                            <?php echo e(__('Refresh')); ?>

                        </button>
                        <button class="btn btn-outline-secondary" id="fullscreen-btn">
                            <i class="ti ti-maximize me-1"></i>
                            <?php echo e(__('Fullscreen')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <!-- Statistics Cards -->
            <div class="row row-deck row-cards mb-3">
                <!-- Total Vehicles Card -->
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Total Vehicles')); ?></div>
                                <div class="ms-auto lh-1">
                                    <i class="ti ti-truck ms-1 text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div id="apex-total-vehicles" style="width: 100%; height: 40px;"></div>
                            <div class="text-muted"><?php echo e(__('Total Vehicles')); ?>: <span id="total-vehicles">0</span></div>
                        </div>
                    </div>
                </div>
                <!-- Moving Vehicles Card -->
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Moving')); ?></div>
                                <div class="ms-auto lh-1">
                                    <i class="ti ti-arrow-right ms-1 text-success" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div id="apex-moving-vehicles" style="width: 100%; height: 40px;"></div>
                            <div class="text-muted"><?php echo e(__('Speed > 0')); ?></div>
                        </div>
                    </div>
                </div>
                <!-- Parked Vehicles Card -->
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Parked')); ?></div>
                                <div class="ms-auto lh-1">
                                    <i class="ti ti-parking-circle ms-1 text-warning" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div id="apex-parked-vehicles" style="width: 100%; height: 40px;"></div>
                            <div class="text-muted"><?php echo e(__('Speed = 0')); ?></div>
                        </div>
                    </div>
                </div>
                <!-- Offline Vehicles Card -->
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Offline')); ?></div>
                                <div class="ms-auto lh-1">
                                    <i class="ti ti-wifi-off ms-1 text-danger" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div id="apex-offline-vehicles" style="width: 100%; height: 40px;"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="row">
                <!-- Sidebar Controls -->
                <div class="col-lg-3">
                    <!-- Auto Refresh Controls -->
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="ti ti-refresh me-2"></i>
                                <?php echo e(__('Auto Refresh')); ?>

                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Refresh Interval')); ?></label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="autoRefreshInterval" value="1" min="1"
                                        max="60" step="1" title="<?php echo e(__('Auto Refresh Interval (minutes)')); ?>">
                                    <span class="input-group-text"><?php echo e(__('min')); ?></span>
                                    <button type="button" class="btn btn-outline-primary" id="auto-refresh-toggle-btn">
                                        <i class="ti ti-player-play"></i> <?php echo e(__('Start')); ?>

                                    </button>
                                    <span class="input-group-text"><span id="countdownTimer"
                                            class="fw-bold">--:--</span></span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="ti ti-filter me-2"></i>
                                <?php echo e(__('Filters & Controls')); ?>

                            </h3>
                        </div>
                        <div class="card-body" id="sidebar-content">
                            <!-- Quick Actions -->
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Quick Actions')); ?></label>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-primary btn-sm" id="show-all-btn">
                                        <i class="ti ti-eye me-1"></i>
                                        <?php echo e(__('Show All')); ?>

                                    </button>
                                    <button class="btn btn-outline-success btn-sm" id="show-moving-btn">
                                        <i class="ti ti-arrow-right me-1"></i>
                                        <?php echo e(__('Show Moving')); ?>

                                    </button>
                                    <button class="btn btn-outline-warning btn-sm" id="show-parked-btn">
                                        <i class="ti ti-parking-circle me-1"></i>
                                        <?php echo e(__('Show Parked')); ?>

                                    </button>
                                </div>
                            </div>

                            <!-- Vehicle Filter -->
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Vehicle Selection')); ?></label>
                                <select id="search-select-vehicle-map1" class="form-select" multiple>
                                    <!-- Will be populated by JavaScript -->
                                </select>
                            </div>

                            <!-- Status Filter -->
                            <div class="mb-3" id="status-filter-container">
                                <label class="form-label"><?php echo e(__('Status Filter')); ?></label>
                                <select id="search-select-status-map1" class="form-select" multiple>
                                    <!-- Will be populated by JavaScript -->
                                </select>
                            </div>

                            <!-- Category Filter -->
                            <div class="mb-3" id="category-filter-container">
                                <label class="form-label"><?php echo e(__('Category Filter')); ?></label>
                                <select id="search-select-category-map1" class="form-select" multiple>
                                    <!-- Will be populated by JavaScript -->
                                </select>
                            </div>

                            <!-- Map Controls -->
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Map Controls')); ?></label>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-secondary btn-sm" id="fit-bounds-btn">
                                        <i class="ti ti-arrows-maximize me-1"></i>
                                        <?php echo e(__('Fit All Vehicles')); ?>

                                    </button>
                                    <button class="btn btn-outline-secondary btn-sm" id="toggle-clusters-btn">
                                        <i class="ti ti-layers me-1"></i>
                                        <?php echo e(__('Toggle Clusters')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Vehicle List -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="ti ti-list me-2"></i>
                                <?php echo e(__('Vehicle List')); ?>

                            </h3>
                            <div class="card-actions">
                                <span class="badge text-white bg-primary" id="vehicle-count">0</span>
                            </div>
                        </div>
                        <div class="card-body p-2">
                            <!-- Vehicle Search -->
                            <div class="mb-2">
                                <div class="input-group input-group-sm">
                                    <span class="input-group-text">
                                        <i class="ti ti-search"></i>
                                    </span>
                                    <input type="text" class="form-control" id="vehicle-search"
                                        placeholder="<?php echo e(__('Search vehicles...')); ?>" autocomplete="off">
                                    <button class="btn btn-outline-secondary btn-sm" id="clear-search" type="button"
                                        title="<?php echo e(__('Clear search')); ?>">
                                        <i class="ti ti-x"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="list-group list-group-flush" id="vehicle-list">
                                <!-- Will be populated by JavaScript -->
                            </div>
                            <!-- No Data State -->
                            <div id="no-data-state" class="text-center py-4" style="display: none;">
                                <i class="ti ti-database-off text-muted" style="font-size: 3rem;"></i>
                                <p class="text-muted mt-2"><?php echo e(__('No vehicle data available')); ?></p>
                            </div>
                            <!-- No Vehicle Selected State -->
                            <div id="no-vehicle-selected-state" class="text-center py-4" style="display: none;">
                                <i class="ti ti-truck-off text-muted" style="font-size: 3rem;"></i>
                                <p class="text-muted mt-2"><?php echo e(__('No vehicles match your selection')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Map Area -->
                <div class="col-lg-9">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h3 class="card-title">
                                    <i class="ti ti-map me-2"></i>
                                    <?php echo e(__('Vehicle Map')); ?>

                                </h3>
                                <div class="card-actions">
                                    <button class="btn btn-sm btn-outline-secondary" id="toggle-sidebar"
                                        title="<?php echo e(__('Toggle Sidebar')); ?>">
                                        <i class="ti ti-chevron-left"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div id="map1" style="height: 70vh; width: 100%;"></div>
                        </div>
                    </div>

                    <!-- Charts Section -->
                    <div class="row mt-3">
                        <!-- Speed Distribution Chart -->
                        <div class="col-lg-6 mb-3">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="ti ti-brand-speedtest me-2"></i>
                                        <?php echo e(__('Speed Distribution')); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="speed-distribution-chart">
                                        <div class="text-center py-4">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                                            </div>
                                            <p class="mt-2 text-muted"><?php echo e(__('Loading chart data...')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Hourly Activity Chart -->
                        <div class="col-lg-6 mb-3">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="ti ti-clock me-2"></i>
                                        <?php echo e(__('Hourly Activity')); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="hourly-activity-chart">
                                        <div class="text-center py-4">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                                            </div>
                                            <p class="mt-2 text-muted"><?php echo e(__('Loading chart data...')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Route Performance Chart -->
                        <div class="col-lg-6 mb-3">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="ti ti-chart-line me-2"></i>
                                        <?php echo e(__('Route Performance')); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="route-performance-chart">
                                        <div class="text-center py-4">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                                            </div>
                                            <p class="mt-2 text-muted"><?php echo e(__('Loading chart data...')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Status Distribution Chart -->
                        <div class="col-lg-6 mb-3">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="ti ti-pie-chart me-2"></i>
                                        <?php echo e(__('Status Distribution')); ?>

                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="status-distribution-chart">
                                        <div class="text-center py-4">
                                            <div class="spinner-border text-primary" role="status">
                                                <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                                            </div>
                                            <p class="mt-2 text-muted"><?php echo e(__('Loading chart data...')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .vehicle-list-item {
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .vehicle-list-item:hover {
            background-color: var(--tblr-bg-surface-hover);
        }

        .vehicle-list-item.active {
            background-color: var(--tblr-primary-bg-subtle);
            border-left: 3px solid var(--tblr-primary);
        }

        .status-indicator {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 8px;
        }

        .status-moving {
            background-color: var(--tblr-success);
        }

        .status-parked {
            background-color: var(--tblr-warning);
        }

        .status-offline {
            background-color: var(--tblr-danger);
        }

        .vehicle-info {
            font-size: 0.875rem;
            color: var(--tblr-secondary);
        }

        .map-controls {
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 1000;
            background: white;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            padding: 5px;
        }

        .sidebar-collapsed .col-lg-3 {
            width: 0 !important;
            height: 0 !important;
            padding: 0 !important;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-collapsed .col-lg-9 {
            width: 100% !important;
            transition: all 0.3s ease;
        }

        .col-lg-3 {
            transition: all 0.3s ease;
        }

        .col-lg-9 {
            transition: all 0.3s ease;
        }

        #toggle-sidebar {
            position: relative;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        #toggle-sidebar:hover {
            transform: scale(1.1);
        }

        @media (max-width: 991.98px) {
            .col-lg-3 {
                order: 2;
            }

            .col-lg-9 {
                order: 1;
            }

            .sidebar-collapsed .col-lg-3 {
                display: none;
            }
        }

        /* Leaflet popup styling */
        .leaflet-popup-content {
            min-width: 200px !important;
        }

        .leaflet-popup-content-wrapper {
            min-width: 200px !important;
        }

        /* Popover styles */
        .popover {
            font-size: 0.875rem;
            border: 1px solid var(--tblr-border-color);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        .popover .popover-arrow::before {
            border-top-color: var(--tblr-border-color);
        }

        .popover .popover-body {
            padding: 0.5rem 0.75rem;
            color: var(--tblr-body-color);
        }

        /* Auto refresh countdown styling */
        #countdownTimer {
            font-family: 'Courier New', monospace;
            font-size: 1.1em;
            color: var(--tblr-primary);
            background-color: var(--tblr-bg-surface);
            padding: 2px 6px;
            border-radius: 4px;
            border: 1px solid var(--tblr-border-color);
        }

        .auto-refresh-active #countdownTimer {
            color: var(--tblr-success);
            font-weight: bold;
        }

        /* Animated Count Display Styles */
        .animated-count-display {
            position: relative;
            display: inline-block;
        }

        .count-number {
            transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
        }

        .count-label {
            transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
        var menuModel = {
        actives : ["a_maps_li","a_map_vehicles-map"],
        shows: ["s_map_li_a","s_map_div"]
    };
    menuSets(menuModel);
    var divIdMap = "map1";

    // Unit variables
    var speedUnit = "";
    var lengthUnit = "";
    var currency = "";
    
    var icon_name = "fa-solid fa-location-arrow";
    var markersVehicles = [];
    var myMap = null;
    var vehicleData = [];
    var isSidebarCollapsed = false;
    var showVehicleMarkers = 1;
    
    // Auto refresh variables
    var autoRefreshInterval = null;
    var countdownInterval = null;
    var nextRefreshTime = null;

    onAppReady(function () {
        // Initialize the page
        initializePage();
    });

    // Initialize the page
    function initializePage() {
        
        // Load initial vehicle data
        loadData();
        
        // Setup event listeners
        setupEventListeners();
        
        // Initialize auto refresh countdown
        initializeAutoRefreshCountdown();

        // Start auto refresh automatically
        startAutoRefresh();

        myMap = new LeafletMap();
        myMap.initMap(divIdMap, {});

        // Initialize popovers using common.js function
        popoverInit();
    }

    // Initialize auto refresh countdown on page load
    function initializeAutoRefreshCountdown() {
        const interval = parseInt($('#autoRefreshInterval').val()) || 1;
        const intervalMs = interval * 60000; // Convert minutes to milliseconds
        
        // Set next refresh time based on current time + interval
        nextRefreshTime = new Date(Date.now() + intervalMs);
        
        // Start countdown immediately
        startCountdown();
        

    }

    // Initialize page with all static data (categories, regions, places) - only once
    function loadData() {
        http.showLoading();
        
        // Wait for sessionSettings to be loaded
        if (!window.sessionSettings) {
            setTimeout(loadData, 100);
            return;
        }
        
        // Use consolidated API endpoint for initialization
        http.post({
            url: "/api/vehicles-map",
        }).then((response) => {

            // Check if response has the expected structure
            if (!response.success || !response.data) {
                throw new Error('Invalid response structure');
            }

            // Extract static data from the new structure
            vehicleData = response.data.vehicles.vehicles || [];
            window.staticCategories = response.data.categories || [];
            window.staticRegions = response.data.regions || [];
            window.staticPlaces = response.data.places || [];
            window.staticCategoriesDevicesMatch = response.data.categoriesDevicesMatch || [];

            console.log("vehicles-map", response.data);

            // Set units after data is loaded
            speedUnit = __(window.sessionSettings.speedUnit || 'km/h');
            lengthUnit = window.sessionSettings.lengthUnit || 'km';
            currency = window.sessionSettings.currency || 'TRY';

            // Initialize map with static data (only on first load)
            if (!window.mapInitialized) {
                initializeMapWithStaticData();
                window.mapInitialized = true;
            }
            
            // Process vehicle data
            processVehicleData(vehicleData);
            
            // Setup filters with categories (only on first load)
            if (!window.filtersInitialized) {
                setupFilters(markersVehicles, window.staticCategories, window.staticCategoriesDevicesMatch);
                window.filtersInitialized = true;
            }
            
            // Update UI
            updateStatistics(vehicleData);
            updateVehicleList(vehicleData);
            
            // Initialize charts after data is loaded (only if not already initialized)
            if (!window.chartsInitialized) {
                initializeCharts();
                window.chartsInitialized = true;
            }
            
            http.hideLoading();
        }).catch((error) => {
            http.hideLoading();
            console.error('Initialization error:', error);
            showConfirmDialog({
                title: __('Error'),
                message: __('Failed to initialize page. Please try again.'),
                type: 'error',
                confirmText: __('OK')
            });
        });
    }

        // Load vehicle data for updates
    function loadVehiclesData() {
        http.post({
            url: "/api/vehicles/list",
        }).then((response) => {

            // Check if response has the expected structure
            if (!response.success || !response.data) {
                throw new Error('Invalid vehicle response structure');
            }

            // Extract vehicle data
            vehicleData = response.data.vehicles || [];

            // Process vehicle data (using existing category match data)
            processVehicleData(vehicleData);
            
            // Update UI
            updateStatistics(vehicleData);
            updateVehicleList(vehicleData);
            
            // Initialize charts after data is loaded (only if not already initialized)
            if (!window.chartsInitialized) {
                initializeCharts();
                window.chartsInitialized = true;
            }
            
        }).catch((error) => {
            console.error('Vehicle data loading error:', error);
            showNotification("error", `Error loading vehicle data: ${error.message || 'Unknown error'}`);
        });
    }

    // Initialize map with static data and vehicle data
    function initializeMapWithStaticData() {
        // Check if map container exists
        if (!document.getElementById(divIdMap)) {
            console.error('Map container not found:', divIdMap);
            return;
        }
        
        if (typeof LeafletMap === 'undefined') {
            console.error('LeafletMap class not found. Make sure map.js is loaded.');
            showConfirmDialog({
                title: __('Error'),
                message: __('Map library not loaded. Please refresh the page.'),
                type: 'error',
                confirmText: __('OK')
            });
            return;
        }
        
        // Add static regions if available (only once)
        if (window.staticRegions && window.staticRegions.length > 0 && !window.staticRegionsAdded) {
            window.staticRegions.forEach(function (region) {
                if (region.polygon_json) {
                    myMap.addPolygon({
                        id: region.id,
                        label: region.name,
                        coords: region.polygon_json,
                        color: 'gray',
                        fillColor: 'gray'
                    });
                }
            });
            window.staticRegionsAdded = true;
    
        }

        // Add static places if available (only once)
        if (window.staticPlaces && window.staticPlaces.length > 0 && !window.staticPlacesAdded) {
            var placeMarkerColor = "gray";
            window.staticPlaces.forEach(function (place) {
                if (place.latitude && place.longitude) {
                    var marker = [{
                        id: place.id,
                        markerClassName: "place-marker",
                        device_id: 0,
                        label: place.name,
                        status: place.status_id,
                        popup: place.name,
                        coord: [
                            parseFloat(place.latitude),
                            parseFloat(place.longitude),
                        ],
                        icon: {
                            name: "fa-solid fa-location-dot",
                            color: placeMarkerColor,
                            direction: 0,
                            className: "",
                        },
                    }];
                    myMap.pinMarkers(marker);
                    
                    if (place.radius && place.radius > 0) {
                        var circle = L.circle([place.latitude, place.longitude], {
                            radius: place.radius,
                            color: placeMarkerColor,
                            fillColor: placeMarkerColor,
                            fillOpacity: 0.2,
                        }).addTo(myMap.mapLet);
                    }
                }
            });
            window.staticPlacesAdded = true;
    
        }

        // Vehicle markers will be added by updateVehicleList function


        initClickVehicleMap();
    }

    // Process vehicle data and create markers
    function processVehicleData(data) {
        markersVehicles = [];

        for (var i = 0; i < data.length; i++) {
            var datetime = data[i].timestamp_ui || dateTimeFormatter(data[i].timestamp);
            var speed = Number(data[i].speed*1).toFixed(2) + " " + speedUnit;
            var ang = Number(data[i].direction*1).toFixed(0) + "°";
            const lat = data[i].latitude;
            const lng = data[i].longitude;
            const vehicleName = data[i].device_data ? data[i].device_data.nm : data[i].name;
            const status = data[i].status_name;

            if (lat == null || lng == null) {
                continue;
            }
            
            let popup = `
                <div class="p-2">
                    <h3 class="mb-2">${vehicleName}</h3>
                    <div class="row g-2">
                        <div class="col-6">
                            <small class="text-muted d-block">
                                <i class="ti ti-road me-1"></i>${__("Status")}
                            </small>
                            <strong>${__(status)}</strong>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">
                                <i class="ti ti-brand-speedtest me-1"></i>${__("Speed")}
                            </small>
                            <strong>${speed}</strong>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">
                                <i class="ti ti-calendar-pin me-1"></i>${__("Time")}
                            </small>
                            <strong>${datetime}</strong>
                        </div>
                        <div class="col-6">
                            <small class="text-muted d-block">
                                <i class="ti ti-compass me-1"></i>${__("Direction")}
                            </small>
                            <strong>${ang}</strong>
                        </div>
                    </div>
                    <div class="mt-3">
                        <button class="btn btn-primary btn-sm w-100 onclick_${divIdMap}_marker" 
                            data-date="${(data[i].timestamp)}" id="${data[i].did}">
                            <i class="ti ti-history me-1"></i>${__("View History")}
                        </button>
                    </div>
                </div>
            `;
            
            // Get categories for this device from the match data
            var deviceCategories = [];
            if (window.categoriesDevicesMatch && window.categoriesDevicesMatch.length > 0) {
                deviceCategories = window.categoriesDevicesMatch
                    .filter(match => match.device_id === data[i].did)
                    .map(match => match.category_id.toString());
            }

            markersVehicles.push({
                id: rand_id(),
                label: vehicleName,
                popup: popup,
                group: "vehicle",
                coord: [(lat * 1), (lng * 1)],
                icon: {
                    name: data[i].direction != null ? "fa-solid fa-location-arrow" : null,
                    color: data[i].status_color || "black",
                    direction: data[i].direction != null ? Number(data[i].direction) : 0,
                    className: "Musteri",
                },
                handler: {
                    status: status,
                    group: deviceCategories,
                    did: data[i].did,
                }
            });
        }
    }

    function initClickVehicleMap() {
        // Setup marker click events
        $(document).on("click", `.onclick_${divIdMap}_marker`, function (e) {
            var date = $(this).attr("data-date");
            const urlModel = {
                did: $(this).attr("id"),
                date: date.split(' ')[0],
                start_time: "00:00",
                end_time: "23:59"
            };
            
            const encodedUrl = Base64Helper.encode(urlModel);
            window.location.href = `/vehicle-map/${encodedUrl}`;
        });
    }

    // Setup filters
    function setupFilters(vehicleMarkers, categories, categoriesDevicesMatch) {
        // Clear existing Select2 instances first
        if ($("#search-select-vehicle-map1").data('select2')) {
            $("#search-select-vehicle-map1").select2('destroy');
        }
        if ($("#search-select-status-map1").data('select2')) {
            $("#search-select-status-map1").select2('destroy');
        }
        if ($("#search-select-category-map1").data('select2')) {
            $("#search-select-category-map1").select2('destroy');
        }

        // Vehicle filter
        var htmlSearhSelectVehicle = `<select id="search-select-vehicle-map1" class="form-select" multiple>`;
        vehicleMarkers.forEach((m) => {
            htmlSearhSelectVehicle += `<option value="${m.id}">${m.label}</option>`;
        });
        htmlSearhSelectVehicle += `</select>`;
        $("#search-select-vehicle-map1").html(htmlSearhSelectVehicle);

        // Status filter - only for vehicle markers that have handler
        var markerStatusList = vehicleMarkers
            .filter((m) => m.handler && m.handler.status)
            .map((m) => m.handler.status);
        
        if (markerStatusList.length > 0) {
            var htmlSearhSelectStatus = `<select id="search-select-status-map1" class="form-select" multiple>`;
            markerStatusList = [...new Set(markerStatusList)].filter((status) => status !== undefined);
            markerStatusList.forEach((status) => {
                if (status == null) return;
                htmlSearhSelectStatus += `<option value="${status}">${__(status)}</option>`;
            });
            htmlSearhSelectStatus += `</select>`;
            $("#search-select-status-map1").html(htmlSearhSelectStatus);
        } else {
            $("#search-select-status-map1").html('<select id="search-select-status-map1" class="form-select" multiple></select>');
        }

        // Category filter - use static categories from DeviceController
        if (categories && categories.length > 0) {
            var htmlSearhSelectCategories = `<select id="search-select-category-map1" class="form-select" multiple>`;
            categories.forEach((category) => {
                if (category && category.name) {
                    htmlSearhSelectCategories += `<option value="${category.id}">${category.name}</option>`;
                }
            });
            htmlSearhSelectCategories += `</select>`;
            $("#search-select-category-map1").html(htmlSearhSelectCategories);
        } else {
            $("#search-select-category-map1").html('<select id="search-select-category-map1" class="form-select" multiple></select>');
        }

        // Store categories devices match for filtering
        window.categoriesDevicesMatch = categoriesDevicesMatch || [];

        setTimeout(() => {
            // Initialize Select2
            $("#search-select-vehicle-map1").select2({
                placeholder: __("Select Vehicle"),
                allowClear: true
            }).on("change", function () {
                filterMarkers();
            });

            $("#search-select-status-map1").select2({
                placeholder: __("Select Status"),
                allowClear: true
            }).on("change", function () {
                filterMarkers();
            });

            $("#search-select-category-map1").select2({
                placeholder: __("Select Category"),
                allowClear: true
            }).on("change", function () {
                filterMarkers();
            });
        }, 100);
    }

    // Filter markers based on selections
    function filterMarkers() {
        var selectedVehicles = $("#search-select-vehicle-map1").val() || [];
        var selectedStatuses = $("#search-select-status-map1").val() || [];
        var selectedCategories = $("#search-select-category-map1").val() || [];



        // First, hide all vehicle markers
        var allVehicleIds = markersVehicles.map(marker => marker.id);
        if (allVehicleIds.length > 0) {
            myMap.filterMarkers({ids: allVehicleIds, show: 0});
        }

        // If no filters are selected, show all vehicles
        if (selectedVehicles.length === 0 && selectedStatuses.length === 0 && selectedCategories.length === 0) {
            if (allVehicleIds.length > 0) {
                myMap.filterMarkers({ids: allVehicleIds, show: 1});
            }
            return;
        }

        var filteredIds = [];

        // if(selectedVehicles.length > 0){
        //     var allselectedVehicles = markersVehicles.filter(marker => selectedVehicles.includes(marker.id));
        //     filteredIds.push(allselectedVehicles);
        //     console.log("selectedVehicles", filteredIds);
        // }

        // if(selectedStatuses.length > 0){
        //     var allselectedStatuses = markersVehicles.filter(marker => selectedStatuses.includes(marker.handler.status));
        //     filteredIds.push(allselectedStatuses);
        //     console.log("selectedStatuses", filteredIds);
        // }

        // if(selectedCategories.length > 0){
        //     var allselectedCategories = markersVehicles.filter(marker => selectedCategories.includes(marker.handler.did));
        //     filteredIds.push(allselectedCategories);
        //     console.log("selectedCategories", filteredIds);
        // }
        
        // markersVehicles.forEach((marker) => {
        //     var vehicleMatch = selectedVehicles.length === 0 || selectedVehicles.includes(marker.id);
        //     var statusMatch = selectedStatuses.length === 0 || 
        //         (marker.handler && marker.handler.status && selectedStatuses.includes(marker.handler.status));
        //     var categoryMatch = selectedCategories.length === 0 ||
        //         window.categoriesDevicesMatch.filter(cat => marker.handler.did == cat.device_id && selectedCategories.includes(cat.category_id.toString())).length > 0;
            
        //     if (vehicleMatch && statusMatch && categoryMatch) {
        //         filteredIds.push(marker.id);
        //     }
        // }); 

        markersVehicles.forEach((marker) => {
            
            var vehicleMatch = selectedVehicles.includes(marker.id);
            if (vehicleMatch) {
                filteredIds.push(marker.id);
            }
            var statusMatch = selectedStatuses.includes(marker.handler.status);
            if (statusMatch) {
                filteredIds.push(marker.id);
            }
            var vehicleCategories = window.staticCategoriesDevicesMatch.filter(c=> c.device_id == marker.handler.did).map(c=> c.category_id.toString());
            if (vehicleCategories.length > 0) {
                var categoryMatch = selectedCategories.filter(c=> vehicleCategories.includes(c)).length > 0;
                if (categoryMatch) {
                    filteredIds.push(marker.id);
                }
            }
        });

        // Show only filtered markers
        if (filteredIds.length > 0) {
            myMap.filterMarkers({ids: filteredIds, show: 1});

            // Fit bounds to visible markers
            myMap.fitBounds(filteredIds);
        }
    }

    // Update statistics
    function updateStatistics(data) {
        var total = data.length;
        var moving = 0;
        var parked = 0;
        var offline = 0;
        
        data.forEach((vehicle) => {
            var speed = parseFloat(vehicle.speed) || 0;
            if (speed > 0) {
                moving++;
            } else if (speed === 0 && vehicle.latitude && vehicle.longitude) {
                parked++;
            } else if (!vehicle.latitude || !vehicle.longitude) {
                offline++;
            }
        });

        // Only update the active vehicles count (the animated counts are handled by createSparklineCharts)
        $("#active-vehicles").text(total - offline);
    }

    // Update vehicle list and map markers
    function updateVehicleList(data) {
        // Show/hide no data state
        if (!data || data.length === 0) {
            $("#vehicle-list").html('');
            $("#no-data-state").show();
            $("#no-vehicle-selected-state").hide();
            $("#vehicle-count").text('0');
            return;
        }
        
        $("#no-data-state").hide();
        $("#no-vehicle-selected-state").hide();
        
        var html = '';
        data.forEach((vehicle, index) => {
            var statusClass = vehicle.status_name == 'Moving' ? 'status-moving' : 'status-parked';
            var statusText = vehicle.status_name == 'Moving' ? __('Moving') : __('Parked');
            var speed = vehicle.status_name == 'Moving' ? Number(vehicle.speed*1).toFixed(1) + " " + speedUnit : 0;
            const vehicleName = vehicle.device_data ? vehicle.device_data.nm : vehicle.name;
            
            html += `
                <div class="list-group-item vehicle-list-item" data-vehicle-id="${index}" data-vehicle-name="${vehicleName.toLowerCase()}">
                    <div class="d-flex align-items-center">
                        <span class="status-indicator ${statusClass}"></span>
                        <div class="flex-grow-1">
                            <div class="fw-semibold">${vehicleName}</div>
                            <div class="vehicle-info">
                                ${statusText} • ${speed}
                            </div>
                        </div>
                        <div class="btn-group btn-group-sm">
                        <button class="btn btn-sm btn-outline-primary px-2 py-1" onclick="focusVehicle(${index})" 
                            data-bs-toggle="popover" data-bs-trigger="hover" data-bs-placement="top" 
                            data-bs-content="${__('Focus on map')}">
                            <i class="ti ti-crosshair"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-info px-2 py-1 onclick_${divIdMap}_marker" 
                            data-date="${vehicle.timestamp}" id="${vehicle.did}"
                            data-bs-toggle="popover" data-bs-trigger="hover" data-bs-placement="top" 
                            data-bs-content="${__('View History')}">
                            <i class="ti ti-history"></i>
                        </button>
                        </div>
                    </div>
                </div>
            `;
        });
        
        $("#vehicle-list").html(html);
        $("#vehicle-count").text(data.length);
        
        // Update vehicle count popover with detailed info
        var popoverContent = data.length + ' ' + __('vehicles') + ' ' + __('currently being tracked');
        popoverAdd({
            divId: 'vehicle-count',
            content: popoverContent,
            trigger: 'hover',
            placement: 'left'
        });
        
        // Update vehicle markers on map
        updateVehicleMarkers();
        
        initClickVehicleMap();
        
        // Initialize popovers for the new buttons
        popoverInit();
        
        // Store original vehicle list for search functionality
        window.originalVehicleList = html;
    }

    // Auto refresh functions
    function startAutoRefresh() {
        const interval = parseInt($('#autoRefreshInterval').val()) || 1;
        
        // If countdown is already running, just setup the auto refresh interval
        if (countdownInterval) {
            setupAutoRefresh(interval * 60000);
        } else {
            // If countdown is not running, initialize it first
            initializeAutoRefreshCountdown();
            setupAutoRefresh(interval * 60000);
        }
        
        showNotification("success", `${__('Auto refresh started')} (${interval} ${__('min')})`);
        
        // Update UI
        $('#auto-refresh-toggle-btn')
            .removeClass('btn-outline-primary')
            .addClass('btn-outline-danger')
            .html('<i class="ti ti-player-stop"></i> ' + __('Stop'));
        $('.card').first().addClass('auto-refresh-active');
    }

    function stopAutoRefresh() {
        if (autoRefreshInterval) {
            clearInterval(autoRefreshInterval);
            autoRefreshInterval = null;
            showNotification("info", __('Auto refresh stopped'));
        }
        
        // Stop countdown
        stopCountdown();
        
        // Update UI
        $('#auto-refresh-toggle-btn')
            .removeClass('btn-outline-danger')
            .addClass('btn-outline-primary')
            .html('<i class="ti ti-player-play"></i> ' + __('Start'));
        $('.card').first().removeClass('auto-refresh-active');
    }

    function setupAutoRefresh(interval = 60000) {
        if (autoRefreshInterval) {
            clearInterval(autoRefreshInterval);
        }
        
        // Set next refresh time
        nextRefreshTime = new Date(Date.now() + interval);
        
        // Start countdown only if not already running
        if (!countdownInterval) {
            startCountdown();
        }
        
        autoRefreshInterval = setInterval(() => {
            // Only refresh vehicle data, not static data
            loadVehiclesData();
            // Reset countdown after refresh
            nextRefreshTime = new Date(Date.now() + interval);
        }, interval);
    }

    function startCountdown() {
        // Clear existing countdown
        if (countdownInterval) {
            clearInterval(countdownInterval);
        }
        
        // Update countdown every second
        countdownInterval = setInterval(() => {
            updateCountdown();
        }, 1000);
        
        // Initial update
        updateCountdown();
    }

    function stopCountdown() {
        if (countdownInterval) {
            clearInterval(countdownInterval);
            countdownInterval = null;
        }
        $('#countdownTimer').text('--:--');
    }

    function updateCountdown() {
        if (!nextRefreshTime) {
            $('#countdownTimer').text('--:--');
            return;
        }
        
        const now = new Date();
        const timeLeft = nextRefreshTime - now;
        
        if (timeLeft <= 0) {
            $('#countdownTimer').text('00:00');
            return;
        }
        
        // Convert to minutes and seconds
        const minutes = Math.floor(timeLeft / 60000);
        const seconds = Math.floor((timeLeft % 60000) / 1000);
        
        // Format as MM:SS
        const formattedTime = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
        $('#countdownTimer').text(formattedTime);
    }

    // Setup event listeners
    function setupEventListeners() {
        // Refresh button
        $("#refresh-btn").click(function() {
            loadVehiclesData();
        });

        // Fullscreen button
        $("#fullscreen-btn").click(function() {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen();
            } else {
                document.exitFullscreen();
            }
        });

        // Auto refresh toggle button
        $("#auto-refresh-toggle-btn").click(function() {
            if (autoRefreshInterval) {
                stopAutoRefresh();
            } else {
                startAutoRefresh();
            }
        });

        // Toggle sidebar
        $("#toggle-sidebar").click(function() {
            isSidebarCollapsed = !isSidebarCollapsed;
            $(".page-body").toggleClass("sidebar-collapsed", isSidebarCollapsed);
            $(this).find("i").toggleClass("ti-chevron-left ti-chevron-right");
            
            // Trigger map resize and refresh after sidebar toggle
            setTimeout(function() {
                if (myMap && myMap.mapLet) {
                    myMap.mapLet.invalidateSize();
                    // Force a map refresh
                    myMap.mapLet._onResize();
                }
            }, 300);
        });

        // Quick action buttons
        $("#show-all-btn").click(function() {
            // Clear all filters
            $("#search-select-vehicle-map1").val(null).trigger('change');
            $("#search-select-status-map1").val(null).trigger('change');
            $("#search-select-category-map1").val(null).trigger('change');
            
            // Show success notification
            showNotification('success', __('All vehicles are now visible'));
        });

        $("#show-moving-btn").click(function() {
            // Clear other filters first
            $("#search-select-status-map1").val(null).trigger('change');
            $("#search-select-category-map1").val(null).trigger('change');
            
            // Filter by speed > 0
            var movingVehicleIds = [];
            vehicleData.forEach((vehicle, index) => {
                // Check if speed is greater than 0 (convert to number first)
                var speed = parseFloat(vehicle.speed) || 0;
                if (speed > 0 && markersVehicles[index]) {
                    movingVehicleIds.push(markersVehicles[index].id);
                }
            });
            
    
            $("#search-select-vehicle-map1").val(movingVehicleIds).trigger('change');
            
            // Show feedback if no moving vehicles
            if (movingVehicleIds.length === 0) {
                showNotification('warning', __('No moving vehicles found. All vehicles are currently parked.'));
            } else {
                showNotification('success', __('Showing ' + movingVehicleIds.length + ' moving vehicles'));
            }
        });

        $("#show-parked-btn").click(function() {
            // Clear other filters first
            $("#search-select-status-map1").val(null).trigger('change');
            $("#search-select-category-map1").val(null).trigger('change');
            
            // Filter by speed = 0
            var parkedVehicleIds = [];
            vehicleData.forEach((vehicle, index) => {
                // Check if speed is 0 or null/undefined (convert to number first)
                var speed = parseFloat(vehicle.speed) || 0;
                if (speed === 0 && markersVehicles[index]) {
                    parkedVehicleIds.push(markersVehicles[index].id);
                }
            });
            
    
            $("#search-select-vehicle-map1").val(parkedVehicleIds).trigger('change');
            
            // Show feedback if no parked vehicles
            if (parkedVehicleIds.length === 0) {
                showNotification('warning', __('No parked vehicles found. All vehicles are currently moving.'));
            } else {
                showNotification('success', __('Showing ' + parkedVehicleIds.length + ' parked vehicles'));
            }
        });

        // Map control buttons
        $("#fit-bounds-btn").click(function() {
            if (markersVehicles.length > 0 && myMap && myMap.mapLet) {
                const bounds = L.latLngBounds(markersVehicles.map(m => m.coord));
                myMap.mapLet.fitBounds(bounds);
            }
        });

        $("#toggle-clusters-btn").click(function() {

            // Get current vehicle marker IDs
            var vehicleMarkerIds = markersVehicles.map(marker => marker.id);
            
            if (showVehicleMarkers == 0) {
                showVehicleMarkers = 1;
            } else {
                showVehicleMarkers = 0;
            }
            // Remove only vehicle markers by their IDs
            if (vehicleMarkerIds.length > 0) {
                myMap.filterMarkers({ids: vehicleMarkerIds, show: showVehicleMarkers});
            }
        });

        // Vehicle search functionality
        $("#vehicle-search").on("input", function() {
            var searchTerm = $(this).val().toLowerCase().trim();
            filterVehicleList(searchTerm);
        });

        $("#clear-search").click(function() {
            $("#vehicle-search").val("");
            filterVehicleList("");
        });

        // Clear search on Escape key
        $(document).on("keydown", function(e) {
            if (e.key === "Escape" && $("#vehicle-search").is(":focus")) {
                $("#vehicle-search").val("");
                filterVehicleList("");
                $("#vehicle-search").blur();
            }
        });
    }

    // Filter vehicle list based on search term
    function filterVehicleList(searchTerm) {
        if (!searchTerm) {
            // Show all vehicles
            $(".vehicle-list-item").show();
            $("#no-vehicle-selected-state").hide();
            var totalCount = $(".vehicle-list-item").length;
            $("#vehicle-count").text(totalCount);
            
            // Update popover content
            var popoverContent = totalCount + ' ' + __('vehicles') + ' ' + __('currently being tracked');
            popoverAdd({
                divId: 'vehicle-count',
                content: popoverContent,
                trigger: 'hover',
                placement: 'left'
            });
            
            // Reinitialize popovers for visible items
            popoverInit();
            return;
        }

        var visibleCount = 0;
        $(".vehicle-list-item").each(function() {
            var vehicleName = $(this).data("vehicle-name");
            if (vehicleName && vehicleName.includes(searchTerm)) {
                $(this).show();
                visibleCount++;
            } else {
                $(this).hide();
            }
        });

        $("#vehicle-count").text(visibleCount);
        
        // Show/hide no vehicle selected state
        if (visibleCount === 0) {
            $("#no-vehicle-selected-state").show();
        } else {
            $("#no-vehicle-selected-state").hide();
        }
        
        // Update popover content for filtered results
        var popoverContent = visibleCount + ' ' + __('vehicles') + ' ' + __('matching') + ' "' + searchTerm + '"';
        popoverAdd({
            divId: 'vehicle-count',
            content: popoverContent,
            trigger: 'hover',
            placement: 'left'
        });
        
        // Reinitialize popovers for visible items
        popoverInit();
        
        // Show notification if no results
        if (visibleCount === 0) {
            showNotification('info', __('No vehicles found matching "' + searchTerm + '"'));
        }
    }

    // Update vehicle markers on map (without affecting places)
    function updateVehicleMarkers() {
        if (!myMap || !myMap.mapLet) {
            console.warn('Map not initialized, skipping vehicle marker update');
            return;
        }

        // Get current vehicle marker IDs
        var vehicleMarkerIds = markersVehicles.map(marker => marker.id);
        
        // Remove only vehicle markers by their IDs
        if (vehicleMarkerIds.length > 0) {
            myMap.filterMarkers({ids: vehicleMarkerIds, show: 0});
        }
        
        // Add updated vehicle markers
        if (markersVehicles.length > 0) {
            const removeIds = myMap.markersAll.filter(m=> m.group === "vehicle").map(m=> m.id);
            if (removeIds.length > 0) {
                myMap.removeMarkers(removeIds);
            }

            myMap.pinMarkers(markersVehicles);
    
        }
    }

    // Focus on specific vehicle
    window.focusVehicle = function(index) {
        if (vehicleData[index] && markersVehicles[index]) {
            myMap.mapLet.setView(markersVehicles[index].coord, 15);
            // Highlight in vehicle list
            $(".vehicle-list-item").removeClass("active");
            $(`.vehicle-list-item[data-vehicle-id="${index}"]`).addClass("active");
        }
    };

    // Cleanup auto refresh intervals on page unload
    $(window).on('beforeunload', function() {
        if (autoRefreshInterval) {
            clearInterval(autoRefreshInterval);
        }
        if (countdownInterval) {
            clearInterval(countdownInterval);
        }
    });

    // Chart Functions
    function initializeCharts() {
        createSparklineCharts();
        createSpeedDistributionChart();
        createHourlyActivityChart();
        createRoutePerformanceChart();
        createStatusDistributionChart();
    }

    // Create sparkline charts for stat cards
    function createSparklineCharts() {
        if (!vehicleData || vehicleData.length === 0) return;

        // Count by status_name (Turkish)
        var movingVehicles = vehicleData.filter(v => v.status_name === 'Moving').length;
        var parkedVehicles = vehicleData.filter(v => v.status_name === 'Stoping').length;  
        var offlineVehicles = vehicleData.filter(v => v.status_name === 'Offline').length;
        var totalVehicles = vehicleData.length;

        $("#total-vehicles").text(totalVehicles);

        // Create ApexChart sparkline for total vehicles
        createTotalVehiclesSparkline(totalVehicles, movingVehicles, parkedVehicles, offlineVehicles);
        // Create animated count displays for other stats
        createAnimatedCountDisplay('apex-moving-vehicles', movingVehicles, '#22c55e');
        createAnimatedCountDisplay('apex-parked-vehicles', parkedVehicles, '#f59e0b');
        createAnimatedCountDisplay('apex-offline-vehicles', offlineVehicles, '#ef4444');
    }

    // Create ApexChart sparkline for total vehicles with status breakdown
    function createTotalVehiclesSparkline(total, moving, parked, offline) {
        $("#apex-total-vehicles").html('');
        
        var options = {
            chart: {
                type: 'bar',
                height: 40,
                sparkline: {
                    enabled: true
                },
                animations: {
                    enabled: false
                }
            },
            series: [{
                name: __('Vehicle Status'),
                data: [moving, parked, offline]
            }],
            colors: ['#22c55e', '#f59e0b', '#ef4444'],
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '70%',
                    borderRadius: 2,
                    distributed: true
                }
            },
            xaxis: {
                categories: [__('Moving'), __('Parked'), __('Offline')],
                labels: { show: false },
                axisBorder: { show: false },
                axisTicks: { show: false }
            },
            yaxis: {
                labels: { show: false }
            },
            tooltip: {
                fixed: {
                    enabled: false
                },
                x: {
                    show: false
                },
                y: {
                    title: {
                        formatter: function (seriesName) {
                            return '';
                        }
                    },
                    formatter: function(value, { seriesIndex, dataPointIndex }) {
                        var statusNames = [__('Moving'), __('Parked'), __('Offline')];
                        return statusNames[dataPointIndex] + ': ' + value;
                    }
                },
                marker: {
                    show: false
                }
            },
            grid: {
                show: false
            }
        };

        try {
            new ApexCharts(document.querySelector("#apex-total-vehicles"), options).render();
        } catch (error) {
            console.error('Error rendering total vehicles sparkline:', error);
        }
    }

    // Create animated count display
    function createAnimatedCountDisplay(elementId, count, color) {
        var element = $("#" + elementId);
        element.html('');
        
        // Create animated count display
        var html = `
            <div class="animated-count-display" style="text-align: center; padding: 8px 0;">
                <div class="count-number" style="font-size: 1.5rem; font-weight: bold; color: ${color}; margin-bottom: 2px;">0</div>
            </div>
        `;
        
        element.html(html);
        
        // Animate the count
        animateCount(element.find('.count-number'), count);
    }

    // Animate count from 0 to target value
    function animateCount(element, targetValue) {
        var currentValue = 0;
        var increment = Math.max(1, Math.ceil(targetValue / 20)); // Smooth animation
        var duration = 1000; // 1 second
        var interval = duration / (targetValue / increment);
        
        var timer = setInterval(function() {
            currentValue += increment;
            if (currentValue >= targetValue) {
                currentValue = targetValue;
                clearInterval(timer);
            }
            element.text(currentValue);
        }, interval);
    }

    // Generate sample sparkline data (keeping for backward compatibility)
    function generateSparklineData(baseValue, variance) {
        var data = [];
        for (var i = 0; i < 24; i++) {
            var randomFactor = 0.8 + (Math.random() * 0.4); // 0.8 to 1.2
            // Ensure minimum value of 1 if baseValue is greater than 0, otherwise use baseValue
            var minValue = baseValue > 0 ? 1 : 0;
            var calculatedValue = Math.max(minValue, Math.round(baseValue * randomFactor * variance));
            data.push(calculatedValue);
        }
        return data;
    }

    // Speed Distribution Chart
    function createSpeedDistributionChart() {

        if (!vehicleData || vehicleData.length === 0) {

            return;
        }

        // Clear loading content
        var chartContainer = document.querySelector("#speed-distribution-chart");
        if (chartContainer) {
            chartContainer.innerHTML = '';

        } else {

            return;
        }

        var speeds = vehicleData.map(function(vehicle) {
            return parseFloat(vehicle.speed) || 0;
        }).filter(function(speed) {
            return speed > 0; // Filter out zero speeds
        });

        // Create speed ranges
        var speedRanges = [
            { min: 0, max: 10, label: '0-10 ' + speedUnit, count: 0 },
            { min: 10, max: 20, label: '10-20 ' + speedUnit, count: 0 },
            { min: 20, max: 30, label: '20-30 ' + speedUnit, count: 0 },
            { min: 30, max: 40, label: '30-40 ' + speedUnit, count: 0 },
            { min: 40, max: 50, label: '40-50 ' + speedUnit, count: 0 },
            { min: 50, max: 60, label: '50-60 ' + speedUnit, count: 0 },
            { min: 60, max: 70, label: '60-70 ' + speedUnit, count: 0 },
            { min: 70, max: 80, label: '70-80 ' + speedUnit, count: 0 },
            { min: 80, max: 90, label: '80-90 ' + speedUnit, count: 0 },
            { min: 90, max: 100, label: '90-100 ' + speedUnit, count: 0 },
            { min: 100, max: Infinity, label: '100+ ' + speedUnit, count: 0 }
        ];

        // Count speeds in each range
        speeds.forEach(function(speed) {
            for (var i = 0; i < speedRanges.length; i++) {
                if (speed >= speedRanges[i].min && speed < speedRanges[i].max) {
                    speedRanges[i].count++;
                    break;
                }
            }
        });

        var options = {
            chart: {
                type: 'bar',
                height: 300,
                toolbar: { show: false }
            },
            series: [{
                name: __('Speed Points'),
                data: speedRanges.map(function(range) { return range.count; })
            }],
            xaxis: {
                categories: speedRanges.map(function(range) { return range.label; }),
                labels: { rotate: -45, style: { fontSize: '10px' } }
            },
            yaxis: {
                title: { text: __('Number of Vehicles') }
            },
            colors: ['#206bc4'],
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    dataLabels: { position: 'top' }
            }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    return val > 0 ? val : '';
                }
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return value + ' ' + __('vehicles');
                    }
                }
            }
        };

        try {
            new ApexCharts(document.querySelector("#speed-distribution-chart"), options).render();
    
        } catch (error) {
            console.error('Error rendering speed distribution chart:', error);
        }
    }

    // Hourly Activity Chart
    function createHourlyActivityChart() {
        if (!vehicleData || vehicleData.length === 0) return;

        // Clear loading content
        var chartContainer = document.querySelector("#hourly-activity-chart");
        if (chartContainer) {
            chartContainer.innerHTML = '';
        }

        // Generate hourly data from vehicle data
        var hourlyData = generateHourlyDataFromVehicles(vehicleData);
        var hours = Array.from({length: 24}, (_, i) => i + ':00');

        var options = {
            chart: {
                type: 'area',
                height: 300,
                toolbar: { show: false }
            },
            series: [
                {
                    name: __('Moving Vehicles'),
                    data: hourlyData.movingVehicles
                },
                {
                    name: __('Total Vehicles'),
                    data: hourlyData.totalVehicles
                }
            ],
            xaxis: {
                categories: hours,
                labels: { style: { fontSize: '10px' } }
            },
            yaxis: [
                {
                    title: { text: __('Vehicles') },
                    labels: { formatter: function(val) { return Math.round(val); } }
                }
            ],
            colors: ['#22c55e', '#206bc4'],
            stroke: { curve: 'smooth', width: 2 },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.2,
                    stops: [0, 100]
                }
            },
            tooltip: {
                shared: true,
                intersect: false,
                y: {
                    formatter: function(value) {
                        return value + ' ' + __('vehicles');
                    }
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    return val > 0 ? Math.round(val) : '';
                }
            }
        };

        new ApexCharts(document.querySelector("#hourly-activity-chart"), options).render();
    }

    // Route Performance Chart
    function createRoutePerformanceChart() {
        if (!vehicleData || vehicleData.length === 0) return;

        // Clear loading content
        var chartContainer = document.querySelector("#route-performance-chart");
        if (chartContainer) {
            chartContainer.innerHTML = '';
        }

        // Calculate performance metrics
        var movingVehicles = vehicleData.filter(function(vehicle) {
            return parseFloat(vehicle.speed) > 0;
        });

        var parkedVehicles = vehicleData.filter(function(vehicle) {
            return parseFloat(vehicle.speed) === 0;
        });

        var offlineVehicles = vehicleData.filter(function(vehicle) {
            return !vehicle.latitude || !vehicle.longitude;
        });

        var avgSpeed = movingVehicles.length > 0 ? 
            movingVehicles.reduce(function(sum, vehicle) {
                return sum + parseFloat(vehicle.speed);
            }, 0) / movingVehicles.length : 0;

        var options = {
            chart: {
                type: 'radialBar',
                height: 300,
                toolbar: { show: false }
            },
            series: [
                Math.round((movingVehicles.length / vehicleData.length) * 100),
                Math.round((parkedVehicles.length / vehicleData.length) * 100),
                Math.round(avgSpeed)
            ],
            labels: [__('Moving'), __('Parked'), __('Avg Speed') + ' (' + speedUnit + ')'],
            colors: ['#22c55e', '#f59e0b', '#206bc4'],
            plotOptions: {
                radialBar: {
                    dataLabels: {
                        name: {
                            fontSize: '12px',
                            color: undefined,
                            offsetY: 0
                        },
                        value: {
                            fontSize: '16px',
                            color: undefined,
                            offsetY: 0,
                            formatter: function(val) {
                                return val;
                            }
                        }
                    }
                }
            }
        };

        new ApexCharts(document.querySelector("#route-performance-chart"), options).render();
    }

    // Status Distribution Chart
    function createStatusDistributionChart() {
        if (!vehicleData || vehicleData.length === 0) return;

        // Clear loading content
        var chartContainer = document.querySelector("#status-distribution-chart");
        if (chartContainer) {
            chartContainer.innerHTML = '';
        }

        var statusCounts = {};
        vehicleData.forEach(function(vehicle) {
            var status = vehicle.status_name || 'Unknown';
            statusCounts[status] = (statusCounts[status] || 0) + 1;
        });

        var statusData = Object.keys(statusCounts).map(function(status) {
            return {
                x: __(status),
                y: statusCounts[status]
            };
        });

        var options = {
            chart: {
                type: 'donut',
                height: 300,
                toolbar: { show: false }
            },
            series: statusData.map(function(item) { return item.y; }),
            labels: statusData.map(function(item) { return item.x; }),
            colors: ['#206bc4', '#22c55e', '#f59e0b', '#ef4444', '#8b5cf6'],
            plotOptions: {
                pie: {
                    donut: {
                        size: '60%',
                        labels: {
                            show: true,
                            total: {
                                show: true,
                                label: __('Total'),
                                formatter: function(w) {
                                    return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                                }
                            }
                        }
                    }
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val, opts) {
                    return opts.w.globals.seriesTotals[opts.seriesIndex];
                }
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return value + ' ' + __('vehicles');
                    }
                }
            }
        };

        new ApexCharts(document.querySelector("#status-distribution-chart"), options).render();
    }

    // Generate hourly data from vehicle data
    function generateHourlyDataFromVehicles(vehicles) {
        var hourlyMoving = new Array(24).fill(0);
        var hourlyTotal = new Array(24).fill(0);

        vehicles.forEach(function(vehicle) {
            if (vehicle.timestamp) {
                var date = new Date(vehicle.timestamp);
                var hour = date.getHours();
                
                hourlyTotal[hour]++;
                
                if (parseFloat(vehicle.speed) > 0) {
                    hourlyMoving[hour]++;
                }
            }
        });

        return {
            movingVehicles: hourlyMoving,
            totalVehicles: hourlyTotal
        };
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\vehicles-map.blade.php ENDPATH**/ ?>