<?php
$alarm_form_id = 307; // After Hours Use alarm form ID
$after_hours = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($after_hours && isset($after_hours['settings_json']) && $after_hours['settings_json']){
if(is_string($after_hours['settings_json'])){
$j = json_decode($after_hours['settings_json'], true) ?: [];
} else {
$j = $after_hours['settings_json'];
}
}
?>

<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">
  <div class="row mb-3">
    <label class="form-selectgroup-item col-6">
      <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($after_hours['status_id']) && $after_hours['status_id'] ? 'checked' : ''); ?>>
      <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
        <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
        <?php echo e(__('Alarm Open')); ?>

      </span>
    </label>
    <label class="form-selectgroup-item col-6">
      <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($after_hours['status_id']) || !$after_hours['status_id'] ? 'checked' : ''); ?>>
      <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
        <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
        <?php echo e(__('Alarm Closed')); ?>

      </span>
    </label>
  </div>

  <div class="card-table table-responsive">
    <table class="table table-vcenter">
      <thead>
        <tr>
          <th><?php echo e(__("Day")); ?></th>
          <th><?php echo e(__("Start")); ?></th>
          <th><?php echo e(__("End")); ?></th>
        </tr>
      </thead>
      <tbody>
        <?php for($i = 1; $i <= 7; $i++): ?> <tr>
          <td class="w-50">
            <?php echo e(__('Day_'.$i)); ?>

          </td>
          <td class="w-25">
            <input type="time" name="start_time_<?php echo e($i); ?>" class="form-control" autocomplete="off"
              value="<?php echo e($j['start_time_'.$i] ?? ''); ?>">
          </td>
          <td class="w-25">
            <input type="time" name="end_time_<?php echo e($i); ?>" class="form-control" autocomplete="off"
              value="<?php echo e($j['end_time_'.$i] ?? ''); ?>">
          </td>
          </tr>
          <?php endfor; ?>
      </tbody>
    </table>
  </div>
  <div class="d-flex justify-content-end p-3">
    <button type="button" class="btn btn-primary" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)"
      id="saveAllBtn_<?php echo e($alarm_form_id); ?>">
      <i class="icon ti ti-device-floppy me-1"></i>
      <?php echo e(__('Save All Settings')); ?>

    </button>
  </div>
</form>

<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\after_hours.blade.php ENDPATH**/ ?>