<?php
$alarm_form_id = 301; // Muayene alarm form ID
$inspection = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($inspection && isset($inspection['settings_json']) && $inspection['settings_json']){
// JSON string ise decode et, array ise direkt kullan
if(is_string($inspection['settings_json'])){
$j = json_decode($inspection['settings_json'], true) ?: [];
} else {
$j = $inspection['settings_json'];
}
}
?>
<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">
    
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($inspection['status_id']) && $inspection['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                <?php echo e(__('Alarm Open')); ?>

            </span>
        </label>
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($inspection['status_id']) || !$inspection['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                <?php echo e(__('Alarm Closed')); ?>

            </span>
        </label>
    </div>

    
    <div class="mb-3">
        <label class="form-label"><?php echo e(__('Inspection Date')); ?></label>
        <div class="row g-2">
            <div class="col-12">
                <input type="date" name="inspection_date" class="form-control"
                    value="<?php echo e($j['inspection_date'] ?? ''); ?>">
            </div>
        </div>
    </div>
    
    
    
    

    <div class="d-flex justify-content-end">
        <button type="button" class="btn btn-primary" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)" id="saveAllBtn">
            <i class="icon ti ti-device-floppy me-1"></i>
            <?php echo e(__('Save All Settings')); ?>

        </button>
    </div>
</form>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\inspection.blade.php ENDPATH**/ ?>