<?php
$alarm_form_id = 306; // Mileage Maintenance alarm form ID
$mileage_maintenance = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($mileage_maintenance && isset($mileage_maintenance['settings_json']) && $mileage_maintenance['settings_json']){
if(is_string($mileage_maintenance['settings_json'])){
$j = json_decode($mileage_maintenance['settings_json'], true) ?: [];
} else {
$j = $mileage_maintenance['settings_json'];
}
}
?>

<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($mileage_maintenance['status_id']) && $mileage_maintenance['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                <?php echo e(__('Alarm Open')); ?>

            </span>
        </label>

        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($mileage_maintenance['status_id']) || !$mileage_maintenance['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                <?php echo e(__('Alarm Closed')); ?>

            </span>
        </label>
    </div>

    <div class="mb-3">
        <div class="row g-2">
            <div class="col-12">
                <label class="form-label"><?php echo e(__('Maintenance Date')); ?></label>
                <input type="date" name="maintenance_km_date" class="form-control"
                    value="<?php echo e($j['maintenance_km_date'] ?? ''); ?>" onchange="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
            </div>
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6"><?php echo e(__('Maintenance Km')); ?></span>
                    <input type="number" name="maintenance_km" min="0" class="form-control" autocomplete="off"
                        value="<?php echo e($j['maintenance_km'] ?? ''); ?>" onchange="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                    <span class="input-group-text">km</span>
                </div>
            </div>
        </div>
    </div>
    
</form>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/partials/forms/settings/mileage_maintenance.blade.php ENDPATH**/ ?>