<?php $__env->startSection('title', __("Sign In")); ?>

<?php $__env->startSection('content'); ?>
<div class="page page-center">
      <div class="container container-tight py-4">
        <div class="text-center mb-4">
          <a href="." class="navbar-brand navbar-brand-autodark">
            <img src="<?php echo e(asset(config('app.assets'))); ?>/img/logo.svg" width="110" height="32" alt="Tabler" class="navbar-brand-image">
        </a>
        </div>
        <div class="card card-md">
          <div class="card-body">
            <h2 class="h2 text-center mb-4"><?php echo e(__("Login to your account")); ?></h2>
            
            <!-- Language Selector -->
            <div class="mb-3">
              <label class="form-label"><?php echo e(__("Language")); ?></label>
              <select class="form-select" id="languageSelector">
                <?php $__currentLoopData = config('app.available_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($code); ?>"><?php echo e($name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            
            <!-- Alert Container -->
            <div id="alertContainer"></div>
              <div class="mb-3">
                <label class="form-label"><?php echo e(__("Email address")); ?></label>
                <input type="email" value="burak@mail.com" id="email" class="form-control" placeholder="your@email.com" autocomplete="off">
              </div>
              <div class="mb-2">
                <label class="form-label">
                  <?php echo e(__("Password")); ?>

                  <span class="form-label-description">
                    <a href="./forgot-password"><?php echo e(__("I forgot password")); ?></a>
                  </span>
                </label>
                <div class="input-group input-group-flat">
                  <input type="password" value="123456" id="password" class="form-control" placeholder="<?php echo e(__("Your password")); ?>" autocomplete="off">
                  <span class="input-group-text">
                    <a href="#" class="link-secondary" data-bs-toggle="tooltip" aria-label="<?php echo e(__("Show password")); ?>" data-bs-original-title="<?php echo e(__("Show password")); ?>">
                        <i class="ti ti-eye"></i>
                    </a>
                  </span>
                </div>
              </div>
              <div class="mb-2">
                <label class="form-check">
                  <input type="checkbox" class="form-check-input">
                  <span class="form-check-label"><?php echo e(__("Remember me on this device")); ?></span>
                </label>
              </div>
              <div class="form-footer">
                <button id="loginFormSubmit" class="btn btn-primary w-100"><?php echo e(__("Sign In")); ?></button>
              </div>
          </div>
        </div>
      </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    // Set language selector value from localStorage on page load
    $(document).ready(function() {
        const settings = JSON.parse(localStorage.getItem('app_settings') || '{}');
        const savedLocale = settings.locale || 'en'; // Default to English
        
        // Set the dropdown value
        $('#languageSelector').val(savedLocale);
    });

    // Language selector change handler
    $('#languageSelector').on('change', function() {
        const selectedLocale = $(this).val();
        
        // Update localStorage
        const settings = JSON.parse(localStorage.getItem('app_settings') || '{}');
        settings.locale = selectedLocale;
        localStorage.setItem('app_settings', JSON.stringify(settings));
        
        // Set cookie
        document.cookie = `app_locale=${selectedLocale}; path=/; max-age=31536000`;
        
        // Reload page to apply new language
        window.location.reload();
    });

    // Alert gösterme fonksiyonu
    function showAlert(type, message) {
        const alertContainer = document.getElementById('alertContainer');
        const alertId = 'alert-' + Date.now();
        
        // Bootstrap alert HTML'i
        const alertHtml = `
            <div class="alert alert-${type} alert-dismissible fade show" id="${alertId}" role="alert">
                <div class="d-flex align-items-center">
                    <i class="ti ti-${type === 'success' ? 'check-circle' : 'alert-circle'} me-2"></i>
                    <div>${message}</div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        `;
        
        alertContainer.innerHTML = alertHtml;
        
        // 5 saniye sonra otomatik kaldır
        setTimeout(() => {
            const alertElement = document.getElementById(alertId);
            if (alertElement) {
                const bsAlert = new bootstrap.Alert(alertElement);
                bsAlert.close();
            }
        }, 5000);
    }

    $("#loginFormSubmit").on("click",function(event) {
        event.preventDefault();

        const $btn = $(this);
        const originalText = $btn.html();
        
        // Disable button and show loading state
        $btn.prop('disabled', true);
        $btn.html('<span class="spinner-border spinner-border-sm me-2" role="status"></span><?php echo e(__("Sign In")); ?>...');

        let email = $('#email').val();
        let password = $('#password').val();

        http.post({
                url: "/login",
                data: {
                    email: email,
                    password: password
                },
            }).then((response) => {
                console.log('Response:', response);
                if (response.success) {
                    showAlert('success', response.message);
                    // Keep button disabled while redirecting
                    $btn.html('<i class="ti ti-check me-2"></i><?php echo e(__("Sign In")); ?>');
                    setTimeout(() => {
                        window.location.href = "/vehicles-map";
                    }, 1000);
                } else {
                    // Re-enable button on error
                    $btn.prop('disabled', false);
                    $btn.html(originalText);
                    showAlert('danger', response.message);
                }
            }).catch((error) => {
                console.error('Login error:', error);
                
                // Re-enable button on error
                $btn.prop('disabled', false);
                $btn.html(originalText);
                
                // Error is now already parsed by common.js
                let errorMessage = '<?php echo e(__("Error occurred during login!")); ?>';
                
                if (typeof error === 'object' && error.message) {
                    errorMessage = error.message;
                } else if (typeof error === 'string') {
                    errorMessage = error;
                }
                
                showAlert('danger', errorMessage);
            });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.sign-in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\login.blade.php ENDPATH**/ ?>