

<?php $__env->startSection('title', __('Profile')); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .cursor-pointer {
        cursor: pointer;
    }

    .avatar-initials {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
        font-size: 1.5rem;
        font-weight: 600;
        color: #fff;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .avatar-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: inherit;
    }

    #profilePhotoInput {
        display: none;
    }

    .profile-photo-upload {
        transition: all 0.3s ease;
    }

    .profile-photo-upload:hover {
        transform: scale(1.05);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xl">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="row align-items-center">
            <div class="col">
                <h2 class="page-title">
                    <i class="fas fa-user me-2"></i>
                    <?php echo e(__('Profile')); ?>

                </h2>
                <div class="text-muted mt-1"><?php echo e(__('Manage your account settings and preferences')); ?></div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="row row-cards">
            <div class="col-lg-4">
                <!-- Profile Card -->
                <div class="card card-sm h-100">
                    <div class="card-body p-4 text-center">
                        <div class="position-relative d-inline-block mb-3">
                            <span class="avatar avatar-xl avatar-rounded profile-photo-upload" id="profileAvatar">
                                <!-- Profile image will be loaded here -->
                            </span>
                            <label for="profilePhotoInput"
                                class="position-absolute bottom-0 end-0 bg-primary text-white rounded-circle p-1 cursor-pointer profile-photo-upload"
                                style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                                <i class="fas fa-camera" style="font-size: 14px;"></i>
                            </label>
                            <input type="file" id="profilePhotoInput" accept="image/*">
                        </div>
                        <h3 class="m-0 mb-1" id="userName"></h3>
                        <div class="text-muted mb-3" id="userEmail"></div>

                        <!-- User Info -->
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="text-muted">
                                    <small class="text-muted d-block"><?php echo e(__('Role')); ?></small>
                                    <div class="text-body fw-bold" id="userRole"></div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-muted">
                                    <small class="text-muted d-block"><?php echo e(__('Member Since')); ?></small>
                                    <div class="text-body fw-bold" id="userCreated"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                <!-- Profile Form -->
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Profile Information')); ?></h3>
                    </div>
                    <div class="card-body">
                        <form id="profileForm">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label required"><?php echo e(__('Name')); ?></label>
                                        <input type="text" class="form-control" id="name" name="nm"
                                            placeholder="<?php echo e(__('Enter your name')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label required"><?php echo e(__('Email')); ?></label>
                                        <input type="email" class="form-control" id="email" name="ml"
                                            placeholder="<?php echo e(__('Enter your email')); ?>" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('New Password')); ?></label>
                                        <input type="password" class="form-control" id="password" name="psw"
                                            placeholder="<?php echo e(__('Leave blank to keep current password')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" placeholder="<?php echo e(__('Confirm new password')); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-check me-2"></i>
                                    <?php echo e(__('Update Profile')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    onAppReady(function() {
    // Load current user data
    loadUserProfile();

    // Profile form submission
    $('#profileForm').on('submit', function(e) {
        e.preventDefault();
        updateProfile();
    });

    // Profile photo upload
    $('#profilePhotoInput').on('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            uploadProfilePhoto(file);
        }
    });

    // Click on avatar to upload photo
    $('#profileAvatar').on('click', function() {
        $('#profilePhotoInput').click();
    });
});

function loadUserProfile() {
    http.get({
        url: '/api/users/me',
    })
    .then(data => {
        if (data.success) {
            const user = data.data;
            $('#name').val(user.nm || '');
            $('#email').val(user.ml || '');
            $('#userName').text(user.nm || '');
            $('#userEmail').text(user.ml || '');
            // Use member_type_name if available, otherwise fallback to function
            $('#userRole').text(__(user.member_type_name));
            $('#userCreated').text(user.created_at ? dateTimeFormatter(user.created_at) : '');
            
            // Load profile image
            loadProfileImage(user.img_url, user.nm);
        } else {
            showNotification('error', data.message || __('Error loading profile data'));
        }
    })
    .catch(error => {
        console.error('Error loading profile:', error);
        showNotification('error', __('Error loading profile data'));
    });
}

function loadProfileImage(imgUrl, userName) {
    const avatar = $('#profileAvatar');
    
    if (imgUrl) {
        // Show profile image
        avatar.html(`<img src="${imgUrl}" alt="${userName}" class="avatar-img">`);
    } else {
        // Show initials
        const initials = userName ? userName.split(' ').map(n => n.charAt(0)).join('').toUpperCase().substring(0, 2) : 'U';
        avatar.html(`<span class="avatar-initials">${initials}</span>`);
    }
}

function uploadProfilePhoto(file) {
    // Validate file type
    if (!file.type.startsWith('image/')) {
        showNotification('error', __('Please select a valid image file'));
        return;
    }

    // Validate file size (max 5MB)
    if (file.size > 5 * 1024 * 1024) {
        showNotification('error', __('Image size must be less than 5MB'));
        return;
    }

    const formData = new FormData();
    formData.append('profile_photo', file);

    // Use jQuery AJAX directly for file uploads
    $.ajax({
        url: '/api/users/me/photo',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function(data) {
            if (data.success) {
                showNotification('success', __('Profile photo updated successfully'));
                // Reload profile to show new image
                loadUserProfile();
            } else {
                showNotification('error', data.message || __('Error uploading profile photo'));
            }
        },
        error: function(xhr) {
            console.error('Error uploading profile photo:', xhr);
            showNotification('error', __('Error uploading profile photo'));
        }
    });
}

function updateProfile() {
    const formData = new FormData(document.getElementById('profileForm'));
    const data = {
        nm: formData.get('nm'),
        email: formData.get('ml')  // Send as 'email' for validation
    };

    if (formData.get('psw')) {
        if (formData.get('psw') !== formData.get('password_confirmation')) {
            showNotification('error', __('Passwords do not match'));
            return;
        }
        data.password = formData.get('psw');  // Send as 'password' for validation
    }

    http.patch({
        url: '/api/users/me',
        data: data
    })
    .then(data => {
        if (data.success) {
            showNotification('success', __('Profile updated successfully'));
            // Reload profile to update displayed name
            loadUserProfile();
        } else {
            showNotification('error', data.message || __('Error updating profile'));
        }
    })
    .catch(error => {
        console.error('Error updating profile:', error);
        showNotification('error', __('Error updating profile'));
    });
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/profile.blade.php ENDPATH**/ ?>