<?php
use App\Helpers\Base64Helper;
use App\Helpers\PublicHelper;
?>


<?php $__env->startSection('title', __('Vehicles') ); ?>

<?php $__env->startSection('content'); ?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    <?php echo e(__('Fleet Management')); ?>

                </div>
                <h2 class="page-title">
                    <?php echo e(__('Vehicles')); ?>

                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Search and Filters Section -->
<div class="page-body">
    <div class="container-xl">
        <!-- Search and Filter Card -->
        <div class="card mb-3">
            <div class="card-body">
                <div class="row g-3">
                    <!-- Search -->
                    <div class="col-md-4">
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="ti ti-search"></i>
                            </span>
                            <input type="text" class="form-control" id="vehicleSearch" 
                                   placeholder="<?php echo e(__('Search vehicles, plates, drivers...')); ?>" autocomplete="off">
                            <button class="btn btn-outline-secondary" type="button" id="clearSearch">
                                <i class="ti ti-x"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Status Filter -->
                    <div class="col-md-2">
                        <select class="form-select" id="statusFilter">
                            <option value=""><?php echo e(__('All Status')); ?></option>
                            <option value="Moving"><?php echo e(__('Moving')); ?></option>
                            <option value="Stoping"><?php echo e(__('Stopped')); ?></option>
                            <option value="Waiting"><?php echo e(__('Waiting')); ?></option>
                            <option value="Pulling"><?php echo e(__('Pulling')); ?></option>
                            <option value="No Signal!"><?php echo e(__('No Signal')); ?></option>
                        </select>
                    </div>
                    
                    <!-- Speed Filter -->
                    <div class="col-md-2">
                        <select class="form-select" id="speedFilter">
                            <option value=""><?php echo e(__('All Speeds')); ?></option>
                            <option value="0-10">0-10 km/h</option>
                            <option value="10-30">10-30 km/h</option>
                            <option value="30-60">30-60 km/h</option>
                            <option value="60+">60+ km/h</option>
                        </select>
                    </div>
                    
                    <!-- Sort By -->
                    <div class="col-md-2">
                        <select class="form-select" id="sortBy">
                            <option value="name"><?php echo e(__('Sort by Name')); ?></option>
                            <option value="status"><?php echo e(__('Sort by Status')); ?></option>
                            <option value="speed"><?php echo e(__('Sort by Speed')); ?></option>
                            <option value="lastUpdate"><?php echo e(__('Sort by Last Update')); ?></option>
                        </select>
                    </div>
                    
                    <!-- View Options -->
                    <div class="col-md-2">
                        <div class="btn-group w-100" role="group">
                            <input type="radio" class="btn-check" name="viewMode" id="gridViewBtn" value="grid" checked>
                            <label class="btn btn-outline-secondary" for="gridViewBtn">
                                <i class="ti ti-layout-grid"></i>
                            </label>
                            <input type="radio" class="btn-check" name="viewMode" id="listViewBtn" value="list">
                            <label class="btn btn-outline-secondary" for="listViewBtn">
                                <i class="ti ti-list"></i>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row row-deck row-cards mb-3">
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="h2 mb-0" id="totalVehicles">0</div>
                            <div class="ms-auto lh-1">
                                <div class="text-muted"><?php echo e(__('Total Vehicles')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="h2 mb-0 text-success" id="movingVehicles">0</div>
                            <div class="ms-auto lh-1">
                                <div class="text-muted"><?php echo e(__('Moving')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="h2 mb-0 text-warning" id="stoppedVehicles">0</div>
                            <div class="ms-auto lh-1">
                                <div class="text-muted"><?php echo e(__('Stopped')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="h2 mb-0 text-danger" id="offlineVehicles">0</div>
                            <div class="ms-auto lh-1">
                                <div class="text-muted"><?php echo e(__('Offline')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Vehicles Container -->
        <div id="vehiclesContainer">
            <!-- Grid View -->
            <div id="gridView" class="view-mode active">
                <div class="row row-deck row-cards" id="vehiclesGrid">
                    <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-lg-4 col-xl-3 vehicle-card" 
                         data-name="<?php echo e(strtolower($item['device_data']['nm'] ?? $item['name'])); ?>" 
                         data-plate="<?php echo e(strtolower($item['plate_number'] ?? '')); ?>" 
                         data-driver="<?php echo e(strtolower($item['driver_name'] ?? '')); ?>"
                         data-status="<?php echo e($item['status_name']); ?>"
                         data-speed="<?php echo e($item['speed'] ?? 0); ?>">
                        <div class="card vehicle-item h-100">
                            <div class="card-body p-4">
                                <!-- Vehicle Icon and Status -->
                                <div class="d-flex align-items-center mb-3">
                                    <div class="avatar avatar-lg me-3">
                                        <div class="avatar-initial rounded-circle" 
                                             style="background-color: <?php echo e($item['status_color']); ?>; transform: rotate(<?php echo e($item['direction']); ?>deg);">
                                            <i class="fa-solid fa-location-arrow text-white"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h3 class="card-title mb-1">
                            <?php if(($item['device_data']['nm'] ?? $item['name']) != ''): ?>
                            <?php echo e($item['device_data']['nm'] ?? $item['name']); ?>

                            <?php else: ?>
                                                <span class="text-danger"><?php echo e(__("Device name not defined")); ?></span>
                            <?php endif; ?>
                        </h3>
                                        <div class="badge" style="background-color: <?php echo e($item['status_color']); ?>; color: white;">
                                            <?php echo e(__($item['status_name'])); ?>

                                        </div>
                                    </div>
                                </div>

                                <!-- Vehicle Details -->
                                <div class="mb-3">
                                    <div class="row g-2">
                                        <div class="col-6">
                                            <div class="text-muted small"><?php echo e(__('Speed')); ?></div>
                                            <div class="fw-semibold"><?php echo e(number_format($item['speed'] ?? 0, 1)); ?> km/h</div>
                                        </div>
                                        <div class="col-6">
                                            <div class="text-muted small"><?php echo e(__('Direction')); ?></div>
                                            <div class="fw-semibold"><?php echo e($item['direction']); ?>°</div>
                                        </div>
                                    </div>
                        </div>

                                <!-- Plate and Driver -->
                                <div class="mb-3">
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="ti ti-id-badge me-2 text-muted"></i>
                            <?php if($item['plate_number'] != ''): ?>
                                            <span class="badge text-white bg-primary"><?php echo e($item['plate_number']); ?></span>
                            <?php else: ?>
                                            <span class="badge text-white bg-danger"><?php echo e(__("Plate not defined")); ?></span>
                            <?php endif; ?>
                        </div>
                                    <div class="d-flex align-items-center">
                                        <i class="ti ti-user me-2 text-muted"></i>
                            <?php if($item['driver_name'] != ''): ?>
                                            <span class="text-muted"><?php echo e($item['driver_name']); ?></span>
                            <?php else: ?>
                                            <span class="text-danger small"><?php echo e(__("Driver not defined")); ?></span>
                            <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Last Update -->
                                <div class="text-muted small mb-3">
                                    <i class="ti ti-clock me-1"></i>
                                    <?php echo e($item['timestamp_ui']); ?>

                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="card-footer p-0">
                                <div class="btn-group w-100" role="group">
                                    <a href="/vehicle-map/<?php echo e(Base64Helper::encode([
                                            'did' => $item['did'],
                                            'date' => date('Y-m-d'),
                                            'start_time' => '00:00',
                                            'end_time' => '23:59'
                                        ])); ?>" 
                                       class="btn btn-outline-primary" 
                                       data-bs-toggle="tooltip" 
                                       title="<?php echo e(__('View on Map')); ?>">
                                        <i class="ti ti-map-2" style="font-size: 1.2rem;"></i>
                                    </a>
                                    <a href="/vehicle-settings/<?php echo e(Base64Helper::encode([
                                            'did' => $item['did']
                                        ])); ?>" 
                                       class="btn btn-outline-secondary" 
                                       data-bs-toggle="tooltip" 
                                       title="<?php echo e(__('Settings')); ?>">
                                        <i class="ti ti-settings" style="font-size: 1.2rem;"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- List View -->
            <div id="listView" class="view-mode">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-vcenter card-table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Vehicle')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Speed')); ?></th>
                                    <th><?php echo e(__('Plate')); ?></th>
                                    <th><?php echo e(__('Driver')); ?></th>
                                    <th><?php echo e(__('Last Update')); ?></th>
                                    <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody id="vehiclesTableBody">
                                <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="vehicle-row" 
                                    data-name="<?php echo e(strtolower($item['device_data']['nm'] ?? $item['name'])); ?>" 
                                    data-plate="<?php echo e(strtolower($item['plate_number'] ?? '')); ?>" 
                                    data-driver="<?php echo e(strtolower($item['driver_name'] ?? '')); ?>"
                                    data-status="<?php echo e($item['status_name']); ?>"
                                    data-speed="<?php echo e($item['speed'] ?? 0); ?>">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm me-3">
                                                <div class="avatar-initial rounded-circle" 
                                                     style="background-color: <?php echo e($item['status_color']); ?>; transform: rotate(<?php echo e($item['direction']); ?>deg);">
                                                    <i class="fa-solid fa-location-arrow text-white"></i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="fw-semibold">
                                                    <?php if(($item['device_data']['nm'] ?? $item['name']) != ''): ?>
                                                        <?php echo e($item['device_data']['nm'] ?? $item['name']); ?>

                                                    <?php else: ?>
                                                        <span class="text-danger"><?php echo e(__("Device name not defined")); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="text-muted small"><?php echo e($item['did']); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge" style="background-color: <?php echo e($item['status_color']); ?>; color: white;">
                                            <?php echo e(__($item['status_name'])); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="fw-semibold"><?php echo e(number_format($item['speed'] ?? 0, 1)); ?> km/h</div>
                                        <div class="text-muted small"><?php echo e($item['direction']); ?>°</div>
                                    </td>
                                    <td>
                                        <?php if($item['plate_number'] != ''): ?>
                                            <span class="badge text-white bg-primary"><?php echo e($item['plate_number']); ?></span>
                                        <?php else: ?>
                                            <span class="badge text-white bg-danger"><?php echo e(__("Not defined")); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item['driver_name'] != ''): ?>
                                            <?php echo e($item['driver_name']); ?>

                                        <?php else: ?>
                                            <span class="text-danger"><?php echo e(__("Not defined")); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="text-muted"><?php echo e($item['timestamp_ui']); ?></div>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                        <a href="/vehicle-map/<?php echo e(Base64Helper::encode([
                                'did' => $item['did'],
                                'date' => \Carbon\Carbon::now()->format('Y-m-d'),
                                'start_time' => '00:01',
                                'end_time' => \Carbon\Carbon::now()->format('H:i')
                                                ])); ?>" 
                                               class="btn btn-outline-primary" 
                                               data-bs-toggle="tooltip" 
                                               title="<?php echo e(__('View on Map')); ?>">
                                                <i class="ti ti-map-2" style="font-size: 1.2rem;"></i>
                                            </a>
                                            
                                            <a href="/vehicle-settings/<?php echo e(Base64Helper::encode([
                                'did' => $item['did']
                                                ])); ?>" 
                                               class="btn btn-outline-secondary" 
                                               data-bs-toggle="tooltip" 
                                               title="<?php echo e(__('Settings')); ?>">
                                                <i class="ti ti-settings" style="font-size: 1.2rem;"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- No Results Message -->
        <div id="noResults" class="text-center py-5" style="display: none;">
            <div class="empty">
                <div class="empty-img">
                    <i class="ti ti-search" style="font-size: 3rem; color: #ccc;"></i>
                </div>
                <p class="empty-title"><?php echo e(__('No vehicles found')); ?></p>
                <p class="empty-subtitle text-muted">
                    <?php echo e(__('Try adjusting your search or filter criteria')); ?>

                </p>
                <div class="empty-action">
                    <button class="btn btn-primary" onclick="clearAllFilters()">
                        <i class="ti ti-refresh me-2"></i>
                        <?php echo e(__('Clear Filters')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .view-mode {
        display: none;
    }

    .view-mode.active {
        display: block;
    }

    .vehicle-card {
        transition: all 0.3s ease;
    }

    .vehicle-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }

    .vehicle-item {
        border: 1px solid var(--tblr-border-color);
        transition: all 0.3s ease;
    }

    .vehicle-item:hover {
        border-color: var(--tblr-primary);
    }

    .avatar-initial {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .vehicle-row {
        transition: background-color 0.2s ease;
    }

    .vehicle-row:hover {
        background-color: var(--tblr-bg-surface-hover);
    }

    .hidden {
        display: none !important;
    }

    /* Loading animation */
    .loading {
        opacity: 0.6;
        pointer-events: none;
    }

    .loading::after {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 20px;
        height: 20px;
        margin: -10px 0 0 -10px;
        border: 2px solid var(--tblr-primary);
        border-top: 2px solid transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Status indicators */
    .status-indicator {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        display: inline-block;
        margin-right: 8px;
    }

    .status-moving { background-color: var(--tblr-success); }
    .status-stopping { background-color: var(--tblr-warning); }
    .status-waiting { background-color: var(--tblr-info); }
    .status-pulling { background-color: var(--tblr-secondary); }
    .status-offline { background-color: var(--tblr-danger); }

    .avatar {
        --tblr-avatar-bg: transparent !important;
        --tblr-avatar-box-shadow-color: transparent !important;
        --tblr-avatar-box-shadow: inset 0 0 0 1px transparent !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    var menuModel = {
        actives: ["vehicles-list"],
        shows: []
    };
    menuSets(menuModel);

    var vehiclesData = <?php echo json_encode($vehicles, 15, 512) ?>;
    var filteredVehicles = vehiclesData;

    onAppReady(function () {
        initializePage();
    });

    function initializePage() {
        initializeTooltips();
        initializeEventListeners();
        updateStatistics();
    }

    function initializeTooltips() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    }

    function initializeEventListeners() {
        // Search functionality
        $('#vehicleSearch').on('input', function() {
            filterVehicles();
        });

        $('#clearSearch').on('click', function() {
            $('#vehicleSearch').val('');
            filterVehicles();
        });

        // Filter functionality
        $('#statusFilter, #speedFilter, #sortBy').on('change', function() {
            filterVehicles();
        });

        // View mode toggle
        $('input[name="viewMode"]').on('change', function() {
            toggleViewMode();
        });

        // Keyboard shortcuts
        $(document).on('keydown', function(e) {
            if (e.ctrlKey && e.key === 'f') {
                e.preventDefault();
                $('#vehicleSearch').focus();
            }
            if (e.key === 'Escape') {
                $('#vehicleSearch').val('').blur();
                filterVehicles();
            }
        });
    }

    function filterVehicles() {
        var searchTerm = $('#vehicleSearch').val().toLowerCase();
        var statusFilter = $('#statusFilter').val();
        var speedFilter = $('#speedFilter').val();
        var sortBy = $('#sortBy').val();

        // Filter vehicles
        filteredVehicles = vehiclesData.filter(function(vehicle) {
            var matchesSearch = !searchTerm || 
                vehicle.name.toLowerCase().includes(searchTerm) ||
                (vehicle.plate_number && vehicle.plate_number.toLowerCase().includes(searchTerm)) ||
                (vehicle.driver_name && vehicle.driver_name.toLowerCase().includes(searchTerm));

            // Fix status filter - handle empty string for "All Status"
            var matchesStatus = true;
            if (statusFilter && statusFilter !== '') {
                matchesStatus = vehicle.status_name === statusFilter;
            }

            var matchesSpeed = !speedFilter || checkSpeedFilter(vehicle.speed || 0, speedFilter);

            return matchesSearch && matchesStatus && matchesSpeed;
        });



        // Sort vehicles        
        filteredVehicles.sort(function(a, b) {
            switch(sortBy) {
                case 'name':
                    return (a.name || '').localeCompare(b.name || '');
                case 'status':
                    return (a.status_name || '').localeCompare(b.status_name || '');
                case 'speed':
                    var speedA = parseFloat(a.speed) || 0;
                    var speedB = parseFloat(b.speed) || 0;
                    return speedB - speedA; // Descending order (highest speed first)
                case 'lastUpdate':
                    var dateA = a.timestamp ? new Date(a.timestamp) : new Date(0);
                    var dateB = b.timestamp ? new Date(b.timestamp) : new Date(0);
                    return dateB - dateA; // Descending order (most recent first)
                default:
                    return 0;
            }
        });

        updateDisplay();
        updateStatistics();
    }

    function checkSpeedFilter(speed, filter) {
        var speedNum = parseFloat(speed) || 0;
        switch(filter) {
            case '0-10': return speedNum >= 0 && speedNum <= 10;
            case '10-30': return speedNum > 10 && speedNum <= 30;
            case '30-60': return speedNum > 30 && speedNum <= 60;
            case '60+': return speedNum > 60;
            default: return true;
        }
    }

    function updateDisplay() {
        var hasResults = filteredVehicles.length > 0;
        
        if (hasResults) {
            $('#noResults').hide();
            // Show the appropriate view container based on current selection
            var currentView = $('input[name="viewMode"]:checked').val();
            if (currentView === 'grid') {
                $('#gridView').show();
                $('#listView').hide();
            } else {
                $('#listView').show();
                $('#gridView').hide();
            }
            updateGridView();
            updateListView();
        } else {
            $('#noResults').show();
            $('#gridView, #listView').hide();
        }
    }

    function updateGridView() {
        var $cards = $('.vehicle-card');
        var $gridContainer = $('#vehiclesGrid');
        
        // First, hide all cards
        $cards.hide();
        
        // Reorder and show vehicles according to the sorted filteredVehicles array
        filteredVehicles.forEach(function(vehicle, index) {
            var vehicleName = vehicle.name.toLowerCase();
            
            var $card = $cards.filter(function() {
                var cardName = $(this).data('name');
                return cardName === vehicleName;
            }).first();
            
            if ($card.length > 0) {
                $card.show();
                // Move the card to the correct position in the grid
                $gridContainer.append($card);
            }
        });
        
        // Reinitialize tooltips for the visible elements
        initializeTooltips();
    }

    function updateListView() {
        var $rows = $('.vehicle-row');
        var $listContainer = $('#vehiclesTableBody');
        
        // First, hide all rows
        $rows.hide();
        
        // Reorder and show vehicles according to the sorted filteredVehicles array
        filteredVehicles.forEach(function(vehicle, index) {
            var vehicleName = vehicle.name.toLowerCase();
            
            var $row = $rows.filter(function() {
                var rowName = $(this).data('name');
                return rowName === vehicleName;
            }).first();
            
            if ($row.length > 0) {
                $row.show();
                // Move the row to the correct position in the list
                $listContainer.append($row);
            }
        });
        
        // Reinitialize tooltips for the visible elements
        initializeTooltips();
    }

    function updateStatistics() {
        // Count visible vehicles instead of using filteredVehicles array
        var total = $('.vehicle-card:visible').length;
        var moving = $('.vehicle-card:visible').filter(function() {
            return $(this).data('status') === 'Moving';
        }).length;
        var stopped = $('.vehicle-card:visible').filter(function() {
            return $(this).data('status') === 'Stoping';
        }).length;
        var offline = $('.vehicle-card:visible').filter(function() {
            return $(this).data('status') === 'No Signal!';
        }).length;

        $('#totalVehicles').text(total);
        $('#movingVehicles').text(moving);
        $('#stoppedVehicles').text(stopped);
        $('#offlineVehicles').text(offline);
    }

    function toggleViewMode() {
        var currentView = $('input[name="viewMode"]:checked').val();
        
        // Hide all view containers
        $('#gridView, #listView').hide();
        
        // Show the selected view container
        if (currentView === 'grid') {
            $('#gridView').show();
        } else {
            $('#listView').show();
        }
        
        // Update the display to refresh the content
        updateDisplay();
    }

    function clearAllFilters() {
        $('#vehicleSearch').val('');
        $('#statusFilter').val('');
        $('#speedFilter').val('');
        $('#sortBy').val('name');
        filterVehicles();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\vehicles-list.blade.php ENDPATH**/ ?>