<?php $__env->startSection('title', __('Regions & Polygons') ); ?>

<?php $__env->startSection('content'); ?>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="/dashboard" class="text-muted"><?php echo e(__('Dashboard')); ?></a> / <?php echo e(__('Geographic Management')); ?>

                </div>
                <h2 class="page-title">
                    <i class="ti ti-map-pin me-2 text-primary"></i>
                    <?php echo e(__('Regions & Polygons')); ?>

                </h2>
                <div class="page-subtitle">
                    <p class="text-muted mb-0">
                        <?php echo e(__('Regions description')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <!-- Quick Stats -->
        <div class="row row-deck row-cards mb-4">
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Total Regions')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold" id="totalRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Active Regions')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-success" id="activeRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Passive Regions')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-secondary" id="passiveRegions">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Regions List & Map -->
        <div class="row row-deck row-cards">
            <!-- Left Panel - Regions List -->
            <div class="col-5">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Regions List')); ?></h3>
                        <div class="card-actions">
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <div id="regionsList"></div>
                            <div id="regionForm"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Right Panel - Map & Polygon Editor -->
            <div class="col-7">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title" id="mapTitle">
                            <i class="fas fa-map text-blue"></i>
                            <?php echo e(__('Select a region to edit polygons')); ?>

                        </h3>
                        <div class="card-actions" id="mapActions" style="display: none;">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-primary" id="drawPolygon">
                                    <i class="fas fa-draw-polygon"></i>
                                    <?php echo e(__('Draw Polygon')); ?>

                                </button>
                                <button type="button" class="btn btn-sm btn-success" id="savePolygons" disabled>
                                    <i class="fas fa-save"></i>
                                    <?php echo e(__('Save Changes')); ?>

                                </button>
                                <button type="button" class="btn btn-sm btn-danger" id="clearPolygons">
                                    <i class="fas fa-trash"></i>
                                    <?php echo e(__('Clear All')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div id="map1"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    #map1 {
        height: calc(100vh - 375px);
        width: 100%;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset(config('app.js_page'))); ?>/regions.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/regions.blade.php ENDPATH**/ ?>