<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Log;
use App\Helpers\PublicHelper;


class ShareJwtTokenData
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->cookie(config('jwt.public_key'));

        //Log::info("ShareJwtTokenData", [
        //        'token' => $token,
        //    ]);

        // Initialize default values
        $cookiePermissions = null;
        $cookieUserId = null;
        $cookieUserType = null;
        $cookieStoreId = null;
        $cookieLocale = 'tr';
        $cookieTimezone = 'Europe/Istanbul';
        $cookieDateFormat = 'd.m.Y';
        $cookieTimeFormat = 'H:i';
        $cookieAutoBackupEnabled = true;
        $cookieBackupFrequency = 'daily';

        if ($token) {
            try {
                $tokenModel = PublicHelper::DecodeJWT($request);
                
                if ($tokenModel) {
                    //ShareJwtTokenData", [
                    //odel' => $tokenModel,
                    //

                // $payload = [
                //     'userId'   => $user['id'],
                //     'storeId'  => $user['sid'],
                //     'owenerId' => $user['mid'],
                //     'userType' => $user['typ'],
                //     'permissions' => $user['permissions'],
                //     'locale'   => 'tr',
                //     'exp'      => time() + (60 * 60 * 24 * 30), // 30 gün
                // ];

                    $cookiePermissions = $tokenModel['permissions'] ?? null;
                    $cookieUserId = $tokenModel['userId'] ?? null;
                    $cookieUserType = $tokenModel['userType'] ?? null;
                    $cookieStoreId = $tokenModel['storeId'] ?? null;
                    $cookieLocale = $tokenModel['locale'] ?? 'tr';
                    $cookieTimezone = $tokenModel['timezone'] ?? 'Europe/Istanbul';
                    $cookieDateFormat = $tokenModel['dateFormat'] ?? 'd.m.Y';
                    $cookieTimeFormat = $tokenModel['timeFormat'] ?? 'H:i';
                    $cookieAutoBackupEnabled = $tokenModel['autoBackupEnabled'] ?? true;
                    $cookieBackupFrequency = $tokenModel['backupFrequency'] ?? 'daily';
                }
            } catch (\Exception $e) {
                // Silently handle JWT decode errors - use default values
                // Don't log errors here as they're expected for unauthenticated requests
            }
        }

        // Blade view'lara otomatik gönder
        View::share('cookieUserType', $cookieUserType);
        View::share('cookiePermissions', $cookiePermissions);
        View::share('cookieUserId', $cookieUserId);
        View::share('cookieStoreId', $cookieStoreId);
        View::share('cookieLocale', $cookieLocale);
        View::share('cookieTimezone', $cookieTimezone);
        View::share('cookieDateFormat', $cookieDateFormat);
        View::share('cookieTimeFormat', $cookieTimeFormat);
        View::share('cookieAutoBackupEnabled', $cookieAutoBackupEnabled);
        View::share('cookieBackupFrequency', $cookieBackupFrequency);

        return $next($request);
    }
}
