<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DeviceCoordinatesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        //{"p":"1","did":"a1a58402fabc488f0","trh":"02.11.2024","sat":"17:24:39","ind":0,"enl":"40.99734","boy":"029.074721","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":35982.5,"yon":22,"A":"","Sensor":"","drx":0}
        return [
            'lat' => $this->lat,
            'lon' => $this->lon,
            'dt' => $this->dt,
            'stts' => $this->stts, //drx
            'drc' => $this->drc, //yon
            'spd' => $this->spd, //hiz
            'icon' => $this->icon,
        ];
    }
}
