<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PlaceResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'member_id' => $this->mid,
            'name'      => $this->nm,
            'order'     => $this->ord,
            'device_count' => $this->pcnt,
            'status_id' => $this->sts,
            'latitude'  => $this->lat,
            'longitude' => $this->lng,
            'active'    => $this->bid,
            'radius'    => $this->radius,
            'match_did'   => $this->match_did,
            'match_status_id' => $this->match_status_id,
            'match_id'   => $this->match_did == null ? 1 : 0,
            'match_name' => $this->match_did == null ? __('Macth') : __('No Match'),
            'created_at'   => $this->created_at,
            'created_by'  => $this->created_by,
            'updated_at'   => $this->updated_at,
            'updated_by'  => $this->updated_by,
        ];
    }
}