<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MemberType extends Model
{
    use HasFactory;

    protected $table = 'vts_member_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'description',
        'is_active',
        'sort_order',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    /**
     * Get all active member types ordered by sort_order
     */
    public static function getActiveTypes()
    {
        return static::where('is_active', true)
                    ->orderBy('sort_order')
                    ->get();
    }

    /**
     * Get member type by ID
     */
    public static function getById($id)
    {
        return static::find($id);
    }

    /**
     * Get member type by name
     */
    public static function getByName($name)
    {
        return static::where('name', $name)->first();
    }

    /**
     * Scope for active member types
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope for ordering by sort_order
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }
}
