<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegionDeviceMatch extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'vts_region_devices';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mid',
        'did',
        'pid',
        'zone_type',
        'bid',
        'price',
        'gsm',
        'email',
        'dt',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'mid' => 'integer',
        'zone_type' => 'integer',
        'bid' => 'integer',
        'dt' => 'datetime'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'mid' => 'integer',
            'zone_type' => 'integer', 
            'bid' => 'integer',
            'dt' => 'datetime'
        ];
    }

    /**
     * Scope for filtering by member ID
     */
    public function scopeByMember($query, $memberId)
    {
        return $query->where('mid', $memberId);
    }

    /**
     * Scope for filtering by device ID
     */
    public function scopeByDevice($query, $deviceId)
    {
        return $query->where('did', $deviceId);
    }

    /**
     * Scope for filtering by region ID
     */
    public function scopeByRegion($query, $regionId)
    {
        return $query->where('pid', $regionId);
    }

    /**
     * Get the region associated with this device.
     */
    public function region()
    {
        return $this->belongsTo(Region::class, 'pid', 'id');
    }

    /**
     * Get the device associated with this record.
     */
    public function device()
    {
        return $this->belongsTo(Device::class, 'did', 'did');
    }

    /**
     * Get the member/user associated with this record.
     */
    public function member()
    {
        return $this->belongsTo(User::class, 'mid', 'id');
    }
}