<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Card extends Component
{
    public $title;
    public $subtitle;
    public $header;
    public $footer;
    public $class;
    public $id;
    public $collapsible;
    public $collapsed;
    public $removable;
    
    /**
     * Create a new component instance.
     */
    public function __construct(
        $title = null,
        $subtitle = null,
        $header = null,
        $footer = null,
        $class = null,
        $id = null,
        $collapsible = false,
        $collapsed = false,
        $removable = false
    ) {
        $this->title = $title;
        $this->subtitle = $subtitle;
        $this->header = $header;
        $this->footer = $footer;
        $this->class = $class;
        $this->id = $id;
        $this->collapsible = $collapsible;
        $this->collapsed = $collapsed;
        $this->removable = $removable;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.card');
    }
}