<?php

namespace App\View\Components;

use Illuminate\View\Component;
use Illuminate\View\View;

class Form extends Component
{
    public $type;
    public $name;
    public $id;
    public $label;
    public $placeholder;
    public $value;
    public $required;
    public $disabled;
    public $readonly;
    public $class;
    public $helpText;
    public $error;
    public $options;
    public $multiple;
    public $rows;
    public $cols;
    public $checked;
    public $inline;
    public $size;

    public function __construct(
        $type = 'text',
        $name = null,
        $id = null,
        $label = null,
        $placeholder = null,
        $value = null,
        $required = false,
        $disabled = false,
        $readonly = false,
        $class = null,
        $helpText = null,
        $error = null,
        $options = [],
        $multiple = false,
        $rows = 3,
        $cols = null,
        $checked = false,
        $inline = false,
        $size = 'md'
    ) {
        $this->type = $type;
        $this->name = $name;
        $this->id = $id ?: $name;
        $this->label = $label;
        $this->placeholder = $placeholder;
        $this->value = $value;
        $this->required = $required;
        $this->disabled = $disabled;
        $this->readonly = $readonly;
        $this->class = $class;
        $this->helpText = $helpText;
        $this->error = $error;
        $this->options = $options;
        $this->multiple = $multiple;
        $this->rows = $rows;
        $this->cols = $cols;
        $this->checked = $checked;
        $this->inline = $inline;
        $this->size = $size;
    }

    public function render(): View
    {
        return view('components.form');
    }
}
