-- --------------------------------------------------------
-- Sunucu:                       localhost
-- Sunucu sürümü:                10.4.32-MariaDB - mariadb.org binary distribution
-- Sunucu İşletim Sistemi:       Win64
-- HeidiSQL Sürüm:               12.11.0.7065
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- tablo yapısı dökülüyor vts_database.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_cache
CREATE TABLE IF NOT EXISTS `vts_cache` (
  `key` varchar(200) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_categories
CREATE TABLE IF NOT EXISTS `vts_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL COMMENT 'Store ID',
  `mid` int(11) NOT NULL COMMENT 'Member ID',
  `ord` int(2) NOT NULL DEFAULT 0 COMMENT 'order',
  `name` varchar(255) NOT NULL COMMENT 'name',
  `pcnt` int(5) NOT NULL DEFAULT 0 COMMENT 'product count',
  `sts` int(1) NOT NULL DEFAULT 0 COMMENT 'status ID',
  `extra_data_json` longtext NOT NULL COMMENT 'Extra data JSON (not currently used)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_category_devices
CREATE TABLE IF NOT EXISTS `vts_category_devices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Category ID reference',
  `device_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Device ID reference',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Assignment creation time',
  `created_by` int(11) NOT NULL DEFAULT 0 COMMENT 'User ID who created the assignment',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_devices
CREATE TABLE IF NOT EXISTS `vts_devices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT 0 COMMENT 'store id',
  `mid` int(11) NOT NULL DEFAULT 0 COMMENT 'member id',
  `did` varchar(17) DEFAULT '0' COMMENT 'cihaz id',
  `gsm` varchar(17) DEFAULT '0' COMMENT 'gsm number',
  `imei` varchar(20) DEFAULT '0' COMMENT 'device IMEI',
  `sts` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Status: [0]Depoda Pasif[1]Depoda Aktif[2]Musteride Aktif[3]Musteride Pasif[4]Teslim Alindi[5]Silindi',
  `is_engine_blocked` int(11) DEFAULT 0 COMMENT 'Engine block status: 0=No, 1=Yes',
  `ord` int(11) NOT NULL DEFAULT 0 COMMENT 'Order',
  `nm` varchar(255) NOT NULL COMMENT 'Name',
  `typ` int(11) DEFAULT NULL COMMENT 'Cihaz marka/model',
  `own` int(11) DEFAULT 0 COMMENT 'Kira/Satış Edinme',
  `category_ids_json` varchar(255) DEFAULT '["0"]' COMMENT 'Category IDs JSON array',
  `usr` varchar(255) DEFAULT NULL COMMENT 'Cihaza tanimli kullanicilar',
  `ga` varchar(255) DEFAULT NULL COMMENT 'Genel Alarmlar',
  `sens` varchar(255) DEFAULT NULL COMMENT 'sensor info',
  `extra_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Extra settings JSON' CHECK (json_valid(`extra_data_json`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_vts_devices_mid_sts` (`mid`,`sts`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_device_alarms
CREATE TABLE IF NOT EXISTS `vts_device_alarms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Member ID',
  `did` varchar(50) NOT NULL DEFAULT '' COMMENT 'device_Werd63 ID',
  `aid` int(11) NOT NULL COMMENT 'Alarm Form ID',
  `sts` int(11) NOT NULL COMMENT 'Status 1 Active/ 0 Pasif',
  `sid` int(11) NOT NULL DEFAULT 0 COMMENT 'Send Notıfıcatıon Status 1 send / 0 not',
  `settings_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'Settings JSON' CHECK (json_valid(`settings_json`)),
  `send_datetime` datetime NOT NULL DEFAULT current_timestamp() COMMENT 'Last notitification send datetime',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_device_logs
CREATE TABLE IF NOT EXISTS `vts_device_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) DEFAULT NULL COMMENT 'IP adres',
  `did` varchar(50) DEFAULT NULL COMMENT 'device ID',
  `latitude` decimal(10,6) DEFAULT NULL COMMENT 'Latitude',
  `longitude` decimal(10,6) DEFAULT NULL COMMENT 'Longitude',
  `coord` point DEFAULT NULL COMMENT 'Coordinate ',
  `notification_sent` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Notification sent status',
  `log_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JSON log data',
  `log_datetime` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Log datetime',
  `dt` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Db datetime',
  PRIMARY KEY (`id`),
  KEY `idx_vts_device_logs_did_id` (`did`,`id`),
  KEY `idx_vts_device_logs_did_log_datetime` (`did`,`log_datetime`)
) ENGINE=MyISAM AUTO_INCREMENT=2493 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_device_logs_copy
CREATE TABLE IF NOT EXISTS `vts_device_logs_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) DEFAULT NULL COMMENT 'IP adres',
  `did` varchar(50) DEFAULT NULL COMMENT 'device ID',
  `latitude` decimal(10,6) DEFAULT NULL COMMENT 'Latitude',
  `longitude` decimal(10,6) DEFAULT NULL COMMENT 'Longitude',
  `coord` point DEFAULT NULL COMMENT 'Coordinate ',
  `notification_sent` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Notification sent status',
  `log_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JSON log data',
  `log_datetime` timestamp NULL DEFAULT NULL COMMENT 'Log datetime',
  `dt` timestamp NULL DEFAULT NULL COMMENT 'Db datetime',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_vts_device_logs_did_id` (`did`,`id`) USING BTREE,
  KEY `idx_vts_device_logs_did_log_datetime` (`did`,`log_datetime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2408777 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ROW_FORMAT=DYNAMIC;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_general_settings
CREATE TABLE IF NOT EXISTS `vts_general_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mid` bigint(20) unsigned NOT NULL COMMENT 'Merchant ID',
  `store_id` bigint(20) unsigned NOT NULL DEFAULT 2 COMMENT 'Store ID',
  `setting_key` varchar(100) NOT NULL COMMENT 'Setting key name',
  `setting_value` text DEFAULT NULL COMMENT 'Setting value',
  `setting_type` varchar(50) NOT NULL DEFAULT 'string' COMMENT 'Data type: string, number, boolean, json',
  `category` varchar(50) NOT NULL DEFAULT 'general' COMMENT 'Setting category: fuel, maintenance, alerts, etc.',
  `description` varchar(255) DEFAULT NULL COMMENT 'Setting description',
  `is_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Is setting active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_mid_store_setting_key` (`mid`,`store_id`,`setting_key`),
  KEY `general_settings_mid_setting_key_index` (`mid`,`setting_key`),
  KEY `general_settings_mid_category_index` (`mid`,`category`),
  KEY `general_settings_store_id_index` (`store_id`),
  KEY `general_settings_mid_store_id_index` (`mid`,`store_id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_member_types
CREATE TABLE IF NOT EXISTS `vts_member_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `member_types_name_unique` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_migrations
CREATE TABLE IF NOT EXISTS `vts_migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_places
CREATE TABLE IF NOT EXISTS `vts_places` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Uye ID',
  `nm` varchar(255) NOT NULL DEFAULT '' COMMENT 'Adi',
  `ord` int(2) NOT NULL DEFAULT 0 COMMENT 'sira',
  `pcnt` int(5) NOT NULL DEFAULT 0 COMMENT 'kac cihaza tanimli',
  `sts` int(1) NOT NULL DEFAULT 1 COMMENT 'yayinda/degil',
  `lat` varchar(50) NOT NULL DEFAULT '',
  `lng` varchar(50) NOT NULL DEFAULT '',
  `radius` int(11) DEFAULT 50,
  `dt` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_place_devices
CREATE TABLE IF NOT EXISTS `vts_place_devices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Uye ID',
  `did` varchar(17) NOT NULL DEFAULT '',
  `pid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Place id',
  `bid` int(11) NOT NULL DEFAULT 0 COMMENT 'Bildirim ID',
  `gsm` varchar(50) NOT NULL DEFAULT '0',
  `email` varchar(50) NOT NULL DEFAULT '0',
  `dt` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_regions
CREATE TABLE IF NOT EXISTS `vts_regions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Uye ID',
  `nm` varchar(255) NOT NULL DEFAULT '' COMMENT 'Adi',
  `ord` int(11) NOT NULL DEFAULT 0 COMMENT 'sira',
  `pcnt` int(11) NOT NULL DEFAULT 0 COMMENT 'kac cihaza tanimli',
  `sts` int(11) NOT NULL DEFAULT 1 COMMENT 'yayinda/degil',
  `ply` longtext DEFAULT NULL COMMENT 'Kordinatlar',
  `poly` polygon DEFAULT NULL,
  `dt` timestamp NOT NULL DEFAULT current_timestamp(),
  `active` int(11) NOT NULL DEFAULT 1 COMMENT 'Active/Pasive',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_region_devices
CREATE TABLE IF NOT EXISTS `vts_region_devices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Uye ID',
  `did` varchar(17) NOT NULL DEFAULT '',
  `pid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Poly id',
  `zone_type` int(2) NOT NULL DEFAULT 0 COMMENT 'Zone type: 0=Alarm off, 1=No entry, 2=No exit',
  `bid` int(1) NOT NULL DEFAULT 0 COMMENT 'Bildirim ID',
  `price` decimal(20,2) DEFAULT NULL COMMENT 'Price of route/parking',
  `gsm` varchar(50) NOT NULL DEFAULT '0',
  `email` varchar(50) NOT NULL DEFAULT '0',
  `dt` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_sessions
CREATE TABLE IF NOT EXISTS `vts_sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `vts_sessions_user_id_index` (`user_id`),
  KEY `vts_sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_users
CREATE TABLE IF NOT EXISTS `vts_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT 0 COMMENT 'Store ID',
  `mid` int(11) NOT NULL DEFAULT 0 COMMENT 'OwenerID',
  `typ` int(11) NOT NULL DEFAULT 0 COMMENT '1 distrubitor 2 bayi 3 admin 4 user',
  `sts` varchar(255) NOT NULL DEFAULT '0' COMMENT 'member status (99 deleted)',
  `ord` int(11) NOT NULL DEFAULT 0 COMMENT 'order',
  `img_url` varchar(50) DEFAULT NULL COMMENT 'profile image url',
  `nm` varchar(255) NOT NULL COMMENT 'name',
  `ml` varchar(255) DEFAULT NULL COMMENT 'email',
  `psw` varchar(255) DEFAULT NULL COMMENT 'password',
  `gsm` varchar(255) DEFAULT NULL COMMENT 'gsm phone',
  `extra_data_json` longtext DEFAULT NULL COMMENT 'General JSON data',
  `msnd` int(11) NOT NULL DEFAULT 22 COMMENT 'sended mail counter',
  `ky` varchar(100) NOT NULL COMMENT 'key',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Veri çıktısı seçilmemişti

-- tablo yapısı dökülüyor vts_database.vts_user_permissions
CREATE TABLE IF NOT EXISTS `vts_user_permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `permission_name` varchar(255) NOT NULL,
  `can_access` tinyint(1) NOT NULL DEFAULT 1,
  `can_view` tinyint(1) NOT NULL DEFAULT 1,
  `can_edit` tinyint(1) NOT NULL DEFAULT 0,
  `can_delete` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1451 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Veri çıktısı seçilmemişti

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
