/**
 * Minified by jsDelivr using UglifyJS v3.3.25.
 * Original file: /npm/leaflet-polylinedecorator@1.6.0/dist/leaflet.polylineDecorator.js
 *
 * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files
 */
!(function (t, n) {
    "object" == typeof exports && "undefined" != typeof module
        ? n(require("leaflet"))
        : "function" == typeof define && define.amd
        ? define(["leaflet"], n)
        : n(t.L);
})(this, function (l) {
    "use strict";
    l = l && l.hasOwnProperty("default") ? l.default : l;
    var c = function (t, n) {
            return (
                ((180 * Math.atan2(n.y - t.y, n.x - t.x)) / Math.PI +
                    90 +
                    360) %
                360
            );
        },
        f = function (t, n) {
            var i = t.value;
            return t.isInPixels ? i / n : i;
        };
    function i(t) {
        if ("string" == typeof t && -1 !== t.indexOf("%"))
            return { value: parseFloat(t) / 100, isInPixels: !1 };
        var n = t ? parseFloat(t) : 0;
        return { value: n, isInPixels: 0 < n };
    }
    var t,
        n,
        o,
        d = function (t, n) {
            return t.x === n.x && t.y === n.y;
        };
    function y(t) {
        return t.reduce(function (t, n, i, o) {
            if (0 < i && !d(n, o[i - 1])) {
                var e = o[i - 1],
                    r = 0 < t.length ? t[t.length - 1].distB : 0,
                    s =
                        ((a = e),
                        (h = (p = n).x - a.x),
                        (u = p.y - a.y),
                        Math.sqrt(h * h + u * u));
                t.push({
                    a: e,
                    b: n,
                    distA: r,
                    distB: r + s,
                    heading: c(e, n),
                });
            }
            var a, p, h, u;
            return t;
        }, []);
    }
    (t = L.Marker.prototype._initIcon),
        (n = L.Marker.prototype._setPos),
        (o = "msTransform" === L.DomUtil.TRANSFORM),
        L.Marker.addInitHook(function () {
            var t =
                this.options.icon &&
                this.options.icon.options &&
                this.options.icon.options.iconAnchor;
            t && (t = t[0] + "px " + t[1] + "px"),
                (this.options.rotationOrigin =
                    this.options.rotationOrigin || t || "center bottom"),
                (this.options.rotationAngle = this.options.rotationAngle || 0),
                this.on("drag", function (t) {
                    t.target._applyRotation();
                });
        }),
        L.Marker.include({
            _initIcon: function () {
                t.call(this);
            },
            _setPos: function (t) {
                n.call(this, t), this._applyRotation();
            },
            _applyRotation: function () {
                this.options.rotationAngle &&
                    ((this._icon.style[L.DomUtil.TRANSFORM + "Origin"] =
                        this.options.rotationOrigin),
                    o
                        ? (this._icon.style[L.DomUtil.TRANSFORM] =
                              "rotate(" + this.options.rotationAngle + "deg)")
                        : (this._icon.style[L.DomUtil.TRANSFORM] +=
                              " rotateZ(" +
                              this.options.rotationAngle +
                              "deg)"));
            },
            setRotationAngle: function (t) {
                return (this.options.rotationAngle = t), this.update(), this;
            },
            setRotationOrigin: function (t) {
                return (this.options.rotationOrigin = t), this.update(), this;
            },
        }),
        (l.Symbol = l.Symbol || {}),
        (l.Symbol.Dash = l.Class.extend({
            options: { pixelSize: 10, pathOptions: {} },
            initialize: function (t) {
                l.Util.setOptions(this, t),
                    (this.options.pathOptions.clickable = !1);
            },
            buildSymbol: function (t, n, i, o, e) {
                var r = this.options,
                    s = Math.PI / 180;
                if (r.pixelSize <= 1)
                    return l.polyline([t.latLng, t.latLng], r.pathOptions);
                var a = i.project(t.latLng),
                    p = -(t.heading - 90) * s,
                    h = l.point(
                        a.x + (r.pixelSize * Math.cos(p + Math.PI)) / 2,
                        a.y + (r.pixelSize * Math.sin(p)) / 2
                    ),
                    u = a.add(a.subtract(h));
                return l.polyline(
                    [i.unproject(h), i.unproject(u)],
                    r.pathOptions
                );
            },
        })),
        (l.Symbol.dash = function (t) {
            return new l.Symbol.Dash(t);
        }),
        (l.Symbol.ArrowHead = l.Class.extend({
            options: {
                polygon: !0,
                pixelSize: 10,
                headAngle: 60,
                pathOptions: { stroke: !1, weight: 2 },
            },
            initialize: function (t) {
                l.Util.setOptions(this, t),
                    (this.options.pathOptions.clickable = !1);
            },
            buildSymbol: function (t, n, i, o, e) {
                return this.options.polygon
                    ? l.polygon(
                          this._buildArrowPath(t, i),
                          this.options.pathOptions
                      )
                    : l.polyline(
                          this._buildArrowPath(t, i),
                          this.options.pathOptions
                      );
            },
            _buildArrowPath: function (t, n) {
                var i = Math.PI / 180,
                    o = n.project(t.latLng),
                    e = -(t.heading - 90) * i,
                    r = (this.options.headAngle / 2) * i,
                    s = e + r,
                    a = e - r,
                    p = l.point(
                        o.x - this.options.pixelSize * Math.cos(s),
                        o.y + this.options.pixelSize * Math.sin(s)
                    ),
                    h = l.point(
                        o.x - this.options.pixelSize * Math.cos(a),
                        o.y + this.options.pixelSize * Math.sin(a)
                    );
                return [n.unproject(p), t.latLng, n.unproject(h)];
            },
        })),
        (l.Symbol.arrowHead = function (t) {
            return new l.Symbol.ArrowHead(t);
        }),
        (l.Symbol.Marker = l.Class.extend({
            options: { markerOptions: {}, rotate: !1 },
            initialize: function (t) {
                l.Util.setOptions(this, t),
                    (this.options.markerOptions.clickable = !1),
                    (this.options.markerOptions.draggable = !1);
            },
            buildSymbol: function (t, n, i, o, e) {
                return (
                    this.options.rotate &&
                        (this.options.markerOptions.rotationAngle =
                            t.heading + (this.options.angleCorrection || 0)),
                    l.marker(t.latLng, this.options.markerOptions)
                );
            },
        })),
        (l.Symbol.marker = function (t) {
            return new l.Symbol.Marker(t);
        });
    var e = function (t) {
        return (
            Array.isArray(t) &&
            ((n = t[0]) instanceof l.LatLng ||
                (Array.isArray(n) && 2 === n.length && "number" == typeof n[0]))
        );
        var n;
    };
    (l.PolylineDecorator = l.FeatureGroup.extend({
        options: { patterns: [] },
        initialize: function (t, n) {
            l.FeatureGroup.prototype.initialize.call(this),
                l.Util.setOptions(this, n),
                (this._map = null),
                (this._paths = this._initPaths(t)),
                (this._bounds = this._initBounds()),
                (this._patterns = this._initPatterns(this.options.patterns));
        },
        _initPaths: function (t, i) {
            var o = this;
            return e(t)
                ? [i ? t.concat([t[0]]) : t]
                : t instanceof l.Polyline
                ? this._initPaths(t.getLatLngs(), t instanceof l.Polygon)
                : Array.isArray(t)
                ? t.reduce(function (t, n) {
                      return t.concat(o._initPaths(n, i));
                  }, [])
                : [];
        },
        _initPatterns: function (t) {
            return t.map(this._parsePatternDef);
        },
        setPatterns: function (t) {
            (this.options.patterns = t),
                (this._patterns = this._initPatterns(this.options.patterns)),
                this.redraw();
        },
        setPaths: function (t) {
            (this._paths = this._initPaths(t)),
                (this._bounds = this._initBounds()),
                this.redraw();
        },
        _parsePatternDef: function (t, n) {
            return {
                symbolFactory: t.symbol,
                offset: i(t.offset),
                endOffset: i(t.endOffset),
                repeat: i(t.repeat),
            };
        },
        onAdd: function (t) {
            (this._map = t),
                this._draw(),
                this._map.on("moveend", this.redraw, this);
        },
        onRemove: function (t) {
            this._map.off("moveend", this.redraw, this),
                (this._map = null),
                l.FeatureGroup.prototype.onRemove.call(this, t);
        },
        _initBounds: function () {
            var t = this._paths.reduce(function (t, n) {
                return t.concat(n);
            }, []);
            return l.latLngBounds(t);
        },
        getBounds: function () {
            return this._bounds;
        },
        _buildSymbols: function (i, o, e) {
            var r = this;
            return e.map(function (t, n) {
                return o.buildSymbol(t, i, r._map, n, e.length);
            });
        },
        _getDirectionPoints: function (t, n) {
            var i = this;
            return t.length < 2
                ? []
                : (function (t, n) {
                      var r = y(t),
                          s = r.length;
                      if (0 === s) return [];
                      for (
                          var i = r[s - 1].distB,
                              o = f(n.offset, i),
                              e = f(n.endOffset, i),
                              a = i * f(n.repeat, i),
                              p = 0 < e ? i * e : 0,
                              h = [],
                              u = 0 < o ? i * o : 0;
                          h.push(u), (u += a), 0 < a && u < i - p;

                      );
                      var l = 0,
                          c = r[0];
                      return h.map(function (t) {
                          for (; t > c.distB && l < s - 1; ) c = r[++l];
                          var n,
                              i,
                              o,
                              e = (t - c.distA) / (c.distB - c.distA);
                          return {
                              pt:
                                  ((n = c.a),
                                  (i = c.b),
                                  (o = e),
                                  i.x !== n.x
                                      ? {
                                            x: n.x + o * (i.x - n.x),
                                            y: n.y + o * (i.y - n.y),
                                        }
                                      : { x: n.x, y: n.y + (i.y - n.y) * o }),
                              heading: c.heading,
                          };
                      });
                  })(
                      t.map(function (t) {
                          return i._map.project(t);
                      }),
                      n
                  ).map(function (t) {
                      return {
                          latLng: i._map.unproject(l.point(t.pt)),
                          heading: t.heading,
                      };
                  });
        },
        redraw: function () {
            this._map && (this.clearLayers(), this._draw());
        },
        _getPatternLayers: function (i) {
            var o = this,
                e = this._map.getBounds().pad(0.1);
            return this._paths.map(function (t) {
                var n = o._getDirectionPoints(t, i).filter(function (t) {
                    return e.contains(t.latLng);
                });
                return l.featureGroup(o._buildSymbols(t, i.symbolFactory, n));
            });
        },
        _draw: function () {
            var n = this;
            this._patterns
                .map(function (t) {
                    return n._getPatternLayers(t);
                })
                .forEach(function (t) {
                    n.addLayer(l.featureGroup(t));
                });
        },
    })),
        (l.polylineDecorator = function (t, n) {
            return new l.PolylineDecorator(t, n);
        });
});
//# sourceMappingURL=/sm/ffe59ef1aeaa6d2f25b56aa75e4d32fe114623b314f6636104b350b349f93563.map
