---
title: Modals
description: Use Bootstrap’s JavaScript modal plugin to add dialogs to your site for lightboxes, user notifications, or completely custom content.
menu: help.docs.components.modals
---

## Default markup

{% capture code %}
<div class="modal{% hide %} d-block position-relative{% endhide %}" tabindex="-1">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            {% include parts/modals/simple.html %}
        </div>
    </div>
</div>
{% endcapture %}
{% include example.html code=code modal=true %}


## Prompt and alert

{% capture code %}
<div class="modal{% hide %} d-block position-relative{% endhide %}" tabindex="-1">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            {% include parts/modals/danger.html %}
        </div>
    </div>
</div>
{% endcapture %}
{% include example.html code=code modal=true %}

{% capture code %}
<div class="modal{% hide %} d-block position-relative{% endhide %}" tabindex="-1">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            {% include parts/modals/success.html %}
        </div>
    </div>
</div>
{% endcapture %}
{% include example.html code=code modal=true %}


## Modal with form

{% capture code %}
<div class="modal{% hide %} d-block position-relative{% endhide %}" tabindex="-1">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            {% include parts/modals/report.html %}
        </div>
    </div>
</div>
{% endcapture %}
{% include example.html code=code modal=true %}
