<?php
/**
 * Step 4: Application Settings
 */

$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_settings'])) {
    $appName = $_POST['app_name'] ?? 'Fleet Tracker Pro';
    $appUrl = $_POST['app_url'] ?? '';
    $timezone = $_POST['timezone'] ?? 'UTC';
    $locale = $_POST['locale'] ?? 'en';
    $installDemo = isset($_POST['install_demo']) ? true : false;
    
    // Save to session
    $_SESSION['install']['settings'] = [
        'app_name' => $appName,
        'app_url' => $appUrl,
        'timezone' => $timezone,
        'locale' => $locale,
        'install_demo' => $installDemo
    ];
    $_SESSION['install']['completed_steps'][4] = true;
    
    // Redirect to next step
    header('Location: ?step=5');
    exit;
}

// Get saved values or defaults
$settings = $_SESSION['install']['settings'] ?? [];
$defaultUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
?>

<h2 class="card-title mb-4">
    <i class="ti ti-settings me-2"></i> Application Settings
</h2>

<p class="text-muted mb-4">
    Configure basic application settings. You can change these later from the admin panel.
</p>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        <h4 class="alert-title"><i class="ti ti-alert-circle"></i> Error</h4>
        <div class="text-muted"><?= htmlspecialchars($error) ?></div>
    </div>
<?php endif; ?>


<form method="POST" id="settingsForm">
    <div class="mb-3">
        <label class="form-label required">Application Name</label>
        <input type="text" name="app_name" class="form-control" 
               value="<?= htmlspecialchars($settings['app_name'] ?? 'Fleet Tracker Pro') ?>" 
               required>
        <small class="form-hint">This will appear in the header and page titles</small>
    </div>

    <div class="mb-3">
        <label class="form-label required">Application URL</label>
        <input type="url" name="app_url" class="form-control" 
               value="<?= htmlspecialchars($settings['app_url'] ?? $defaultUrl) ?>" 
               required
               placeholder="https://yourdomain.com">
        <small class="form-hint">Your website URL (without trailing slash)</small>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Timezone</label>
            <select name="timezone" class="form-select">
                <option value="UTC" <?= ($settings['timezone'] ?? 'UTC') === 'UTC' ? 'selected' : '' ?>>UTC</option>
                <option value="Europe/Istanbul" <?= ($settings['timezone'] ?? '') === 'Europe/Istanbul' ? 'selected' : '' ?>>Europe/Istanbul</option>
                <option value="Europe/London" <?= ($settings['timezone'] ?? '') === 'Europe/London' ? 'selected' : '' ?>>Europe/London</option>
                <option value="America/New_York" <?= ($settings['timezone'] ?? '') === 'America/New_York' ? 'selected' : '' ?>>America/New_York</option>
                <option value="America/Los_Angeles" <?= ($settings['timezone'] ?? '') === 'America/Los_Angeles' ? 'selected' : '' ?>>America/Los_Angeles</option>
                <option value="Asia/Dubai" <?= ($settings['timezone'] ?? '') === 'Asia/Dubai' ? 'selected' : '' ?>>Asia/Dubai</option>
                <option value="Asia/Tokyo" <?= ($settings['timezone'] ?? '') === 'Asia/Tokyo' ? 'selected' : '' ?>>Asia/Tokyo</option>
            </select>
        </div>

        <div class="col-md-6 mb-3">
            <label class="form-label">Default Language</label>
            <select name="locale" class="form-select">
                <option value="en" <?= ($settings['locale'] ?? 'en') === 'en' ? 'selected' : '' ?>>English</option>
                <option value="tr" <?= ($settings['locale'] ?? '') === 'tr' ? 'selected' : '' ?>>Türkçe</option>
            </select>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-check form-switch">
            <input class="form-check-input" type="checkbox" name="install_demo" 
                   <?= ($settings['install_demo'] ?? true) ? 'checked' : '' ?>>
            <span class="form-check-label">Install Demo Data</span>
        </label>
        <small class="form-hint">
            Includes sample vehicles, users, and GPS logs for testing
        </small>
    </div>

    <div class="alert alert-info">
        <i class="ti ti-bulb me-2"></i>
        <strong>Tip:</strong> Installing demo data is recommended for first-time users to explore all features.
    </div>

    <div class="d-flex justify-content-between mt-4">
        <a href="?step=2" class="btn">
            <i class="ti ti-arrow-left me-2"></i> Back
        </a>
        <button type="submit" name="save_settings" class="btn btn-primary">
            Save & Continue
            <i class="ti ti-arrow-right ms-2"></i>
        </button>
    </div>
</form>

