@php
    $alertClasses = ['alert', 'alert-' . $type];
    if ($dismissible) {
        $alertClasses[] = 'alert-dismissible';
    }
    if ($class) {
        $alertClasses[] = $class;
    }
    $alertClass = implode(' ', $alertClasses);
    
    $alertId = $id ? 'id="' . $id . '"' : '';
    $alertDataAttributes = '';
    if ($autoHide) {
        $alertDataAttributes .= ' data-auto-hide="true" data-delay="' . $delay . '"';
    }
    
    // Default icons for each type
    $defaultIcons = [
        'success' => 'check-circle',
        'danger' => 'alert-circle',
        'warning' => 'alert-triangle',
        'info' => 'info-circle',
        'primary' => 'info-circle',
        'secondary' => 'info-circle'
    ];
    
    $iconName = $icon ?: ($defaultIcons[$type] ?? 'info-circle');
    $iconHtml = '<i class="ti ti-' . $iconName . '"></i>';
@endphp

<div class="{{ $alertClass }}" {{ $alertId }}{{ $alertDataAttributes }} role="alert">
    @if($icon || $title)
        <div class="d-flex align-items-center">
            @if($icon)
                <div class="me-2">
                    {!! $iconHtml !!}
                </div>
            @endif
            @if($title)
                <div class="flex-fill">
                    <h4 class="alert-title">{{ $title }}</h4>
                </div>
            @endif
        </div>
    @endif
    
    <div class="alert-content">
        {{ $slot }}
    </div>
    
    @if($dismissible)
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    @endif
</div>

@if($autoHide)
<script>
document.addEventListener('DOMContentLoaded', function() {
    const alert = document.querySelector('[data-auto-hide="true"]');
    if (alert) {
        setTimeout(function() {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, {{ $delay }});
    }
});
</script>
@endif