@php
    $cardClasses = ['card'];
    if ($class) {
        $cardClasses[] = $class;
    }
    $cardClass = implode(' ', $cardClasses);
    
    $uniqueId = $id ?: 'card-' . uniqid();
    $cardId = 'id="' . $uniqueId . '"';
    $cardDataAttributes = '';
    if ($collapsible) {
        $cardDataAttributes .= ' data-bs-toggle="collapse" data-bs-target="#' . $uniqueId . '-body"';
    }
@endphp

<div class="{{ $cardClass }}" {{ $cardId }}{{ $cardDataAttributes }}>
    @if($title || $subtitle || $header || $collapsible || $removable)
        <div class="card-header">
            @if($header)
                {!! $header !!}
            @else
                <div class="d-flex w-100 align-items-center">
                    <div class="flex-fill">
                        @if($title)
                            <h3 class="card-title">{{ $title }}</h3>
                        @endif
                        @if($subtitle)
                            <div class="card-subtitle">{{ $subtitle }}</div>
                        @endif
                    </div>
                    <div class="card-actions ms-auto">
                        @if($collapsible)
                            <button type="button" class="btn btn-action" data-bs-toggle="collapse" data-bs-target="#{{ $uniqueId }}-body" id="{{ $uniqueId }}-toggle">
                                <i class="ti ti-chevron-{{ ($collapsed === true || $collapsed === 'true') ? 'down' : 'up' }}" id="{{ $uniqueId }}-icon"></i>
                            </button>
                        @endif
                        @if($removable)
                            <button type="button" class="btn btn-action" onclick="this.closest('.card').remove()">
                                <i class="ti ti-x"></i>
                            </button>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    @endif
    
    <div class="card-body {{ $collapsible ? 'collapse' : '' }} {{ $collapsible && ($collapsed !== true && $collapsed !== 'true') ? 'show' : '' }}" id="{{ $uniqueId }}-body">
        {{ $slot }}
    </div>
    
    @if($footer)
        <div class="card-footer">
            {!! $footer !!}
        </div>
    @endif
</div>

@if($collapsible)
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleButton = document.getElementById('{{ $uniqueId }}-toggle');
    const icon = document.getElementById('{{ $uniqueId }}-icon');
    const targetBody = document.getElementById('{{ $uniqueId }}-body');
    
    if (toggleButton && icon && targetBody) {
        // İlk durumu kontrol et ve icon'u ayarla
        const isCollapsed = !targetBody.classList.contains('show');
        icon.className = isCollapsed ? 'ti ti-chevron-down' : 'ti ti-chevron-up';
        
        // Bootstrap collapse event'lerini dinle
        targetBody.addEventListener('show.bs.collapse', function() {
            icon.className = 'ti ti-chevron-up';
        });
        
        targetBody.addEventListener('hide.bs.collapse', function() {
            icon.className = 'ti ti-chevron-down';
        });
    }
});
</script>
@endif