@php
    $modalClass = 'modal fade';
    $dialogClass = 'modal-dialog';
    $contentClass = 'modal-content';
    $headerClass = 'modal-header';
    $bodyClass = 'modal-body';
    $footerClass = 'modal-footer';
    
    // Size classes
    switch ($size) {
        case 'sm':
            $dialogClass .= ' modal-sm';
            break;
        case 'lg':
            $dialogClass .= ' modal-lg';
            break;
        case 'xl':
            $dialogClass .= ' modal-xl';
            break;
        case 'fullscreen':
            $dialogClass .= ' modal-fullscreen';
            break;
    }
    
    // Centered
    if ($centered) {
        $dialogClass .= ' modal-dialog-centered';
    }
    
    // Scrollable
    if ($scrollable) {
        $dialogClass .= ' modal-dialog-scrollable';
    }
    
    // Custom classes
    if ($class) {
        $modalClass .= ' ' . $class;
    }
    if ($headerClass) {
        $headerClass .= ' ' . $headerClass;
    }
    if ($bodyClass) {
        $bodyClass .= ' ' . $bodyClass;
    }
    if ($footerClass) {
        $footerClass .= ' ' . $footerClass;
    }
    
    // Backdrop and keyboard attributes
    $dataAttributes = '';
    if (!$backdrop) {
        $dataAttributes .= ' data-bs-backdrop="static"';
    }
    if (!$keyboard) {
        $dataAttributes .= ' data-bs-keyboard="false"';
    }
@endphp

<div class="{{ $modalClass }}" id="{{ $id }}" tabindex="-1" aria-labelledby="{{ $id }}-title" aria-hidden="true"{{ $dataAttributes }}>
    <div class="{{ $dialogClass }}">
        <div class="{{ $contentClass }}">
            @if($title || $showCloseButton)
                <div class="{{ $headerClass }}">
                    @if($title)
                        <h5 class="modal-title" id="{{ $id }}-title">
                            {{ $title }}
                        </h5>
                    @endif
                    @if($showCloseButton)
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    @endif
                </div>
            @endif
            
            <div class="{{ $bodyClass }}">
                {{ $slot }}
            </div>
            
            @if($footer || $slot->has('footer'))
                <div class="{{ $footerClass }}">
                    @if($slot->has('footer'))
                        {{ $footer }}
                    @else
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            {{ $closeButtonText }}
                        </button>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
