@php
$alarm_form_id = 304; // High Speed Alarm form ID
$high_speed = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($high_speed && isset($high_speed['settings_json']) && $high_speed['settings_json']){
if(is_string($high_speed['settings_json'])){
$j = json_decode($high_speed['settings_json'], true) ?: [];
} else {
$j = $high_speed['settings_json'];
}
}
@endphp

<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">

    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{ $alarm_form_id }}" value="1" class="form-selectgroup-input" {{
                isset($high_speed['status_id']) && $high_speed['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                {{ __('Alarm Open') }}
            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_{{ $alarm_form_id }}" value="0" class="form-selectgroup-input" {{
                !isset($high_speed['status_id']) || !$high_speed['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                {{ __('Alarm Closed') }}
            </span>
        </label>
    </div>
    <div class="mb-3">
        <div class="row g-2">
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6">{{ __('Speed Limit') }}</span>
                    <input type="number" name="speed_limit" min="0" class="form-control" autocomplete="off"
                        value="{{ $j['speed_limit'] ?? '' }}" onchange="saveAlarmSettings({{ $alarm_form_id }})">
                </div>
            </div>
        </div>
    </div>
</form>
{{--
Note:
<script>
    vehicle-settings.blade.php
    function saveAlarmSettings(alarm_form_id) {
</script>
--}}