<div class="card-table table-responsive">
    <table class="table table-vcenter">
        <thead>
            <tr>
                <th>{{ __("Region") }}</th>
                <th>{{ __("Price") }}</th>
                <th>{{ __("Status") }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ( $regions as $region )
            @if($region["active"] == 1)
            <tr>
                <td class="">
                    {{ $region["name"] }}
                </td>
                <td style="width: 28%;">
                    <input type="number" name="region_price" class="form-control" step="1" min="0"
                        value="{{ $region['price'] ?? '' }}" placeholder="0.00"
                        onchange="setRegionDevicePrice({{ $region['id'] }}, this.value)">
                </td>
                <td>

                    <select name="region_status" class="form-select"
                        onchange="setRegionDeviceStatus({{ $region['id'] }}, this.value)">
                        <option value="0" {{ $region["match_status_id"]==0 ? 'selected' : '' }}>
                            {{ __("Alarm Off") }}
                        </option>
                        <option value="1" {{ $region["match_status_id"]==1 ? 'selected' : '' }}>
                            {{ __("Can't Enter") }}
                        </option>
                        <option value="2" {{ $region["match_status_id"]==2 ? 'selected' : '' }}>
                            {{ __("Can't Go Out") }}
                        </option>
                    </select>

                </td>
            </tr>
            @endif
            @endforeach
        </tbody>
    </table>
</div>
<script>
    function setRegionDeviceStatus(regionId, status) {
        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            region_id: regionId,
            status: status
        });

        http.post({
            url: "/region-set-device",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "{{ __("Region status updated successfully") }}");
            } else {
                showNotification("error", "{{ __("Error updating region status") }} ");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "{{ __("Error updating region status") }}");
        });
    }

    function setRegionDevicePrice(regionId, price) {
        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            region_id: regionId,
            price: price
        });

        http.post({
            url: "/region-set-device-price",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "{{ __("Region price updated successfully") }}");
            } else {
                showNotification("error", "{{ __("Error updating region price") }}");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "{{ __("Error updating region price") }}");
        });
    }
</script>