<div class="card-table table-responsive">
    <div class="p-3">
        <?php echo e(__('Receive notifications via the mobile app when entering or exiting the point.')); ?>

    </div>
    <table class="table table-vcenter">
        <thead>
            <tr>
                <th><?php echo e(__("Place")); ?></th>
                <th><?php echo e(__("Alarm")); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $places; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($item["status_id"] == 1): ?>
            <tr>
                <td class="w-50">
                    <?php echo e($item["name"]); ?>

                </td>
                <td class="td-truncate">

                    <label class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" <?php echo e($item['match_status_id'] ? "checked" : ""); ?>

                            onchange="setPlaceDeviceStatus(<?php echo e($item['id']); ?>, this)">
                    </label>

                </td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<script>
    function setPlaceDeviceStatus(placeId, _this) {

        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            place_id: placeId,
            status: $(_this).is(":checked") ? 1 : 0
        });

        http.post({
            url: "/place-set-device",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "Region status updated successfully");
            } else {
                showNotification("error", "Error updating region status");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "Error updating region status");
        });
    }
</script><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\places.blade.php ENDPATH**/ ?>