

<?php $__env->startSection('title', __('Reports') ); ?>

<?php $__env->startSection('content'); ?>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    <?php echo e(__("Analysis and Statistics")); ?>

                </div>
                <h2 class="page-title">
                    <?php echo e(__("Reports")); ?>

                </h2>
                <div class="alert alert-warning alert-dismissible fade show mt-3" role="alert">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <div>
                            <strong><?php echo e(__('Important Notice:')); ?></strong> <?php echo e(__('The speed and distance (km) data in these reports are based on GPS calculations. Due to factors like satellite signal quality, environmental conditions, and device positioning, slight deviations may occur. Therefore, the data should be considered approximate.')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <!-- Rapor Kategorileri -->
        <div class="row row-cards">
            <!-- Operasyonel Raporlar -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-chart-line me-2"></i>
                            <?php echo e(__("Operational Reports")); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_daily','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-blue text-white avatar">
                                                    <i class="ti ti-route"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Daily Movement Summary")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Vehicle movements, distance
                                                    and time analysis")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/daily-summary/all" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_parking','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-red text-white avatar">
                                                    <i class="ti ti-parking"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Parking/Stop Analysis")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Parking duration and
                                                    location analysis")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/parking-analysis" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_visit','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-purple text-white avatar">
                                                    <i class="ti ti-map-pin"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Visit Report")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Places entry/exit
                                                    tracking")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/visit-report" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <!-- <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-green text-white avatar">
                                                    <i class="ti ti-map-2"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Route Efficiency")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Optimal route usage analysis")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/route-efficiency" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div> -->

                        </div>
                    </div>
                </div>
            </div>

            <!-- Güvenlik ve Uyum Raporları -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-shield-check me-2"></i>
                            <?php echo e(__("Security and Compliance Reports")); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_speed','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-orange text-white avatar">
                                                    <i class="ti ti-brand-speedtest"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Speed Violation Report")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Speed limit violations and
                                                    infractions")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/speed-violations/all" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_harsh_driving','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-yellow text-white avatar">
                                                    <i class="ti ti-arrow-autofit-content"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Harsh Driving Analysis")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Sudden acceleration and
                                                    deceleration detection")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/harsh-driving" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_zone_violations','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-purple text-white avatar">
                                                    <i class="ti ti-polygon"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Zone Violation Report")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Restricted area
                                                    entry/exits")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/zone-violations" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_after_hours','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-dark text-white avatar">
                                                    <i class="ti ti-clock"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("After Hours Report")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Vehicle usage outside
                                                    business hours")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/after-hours/all" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_working_hours','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-cyan text-white avatar">
                                                    <i class="ti ti-clock"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Working Hours Utilization")); ?>

                                                </div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Analyze vehicle usage,
                                                    efficiency, and compliance during business hours.")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/working-hours" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Working Hours Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Maliyet ve Verimlilik Raporları -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-report-money me-2"></i>
                            <?php echo e(__("Cost and Efficiency Reports")); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_fuel','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-teal text-white avatar">
                                                    <i class="ti ti-gas-station"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Fuel Consumption Analysis")); ?>

                                                </div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Fuel efficiency and cost")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/fuel-consumption" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_toll','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-indigo text-white avatar">
                                                    <i class="ti ti-building-bridge-2"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Toll/Bridge Passages")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("OGS/HGS cost tracking")); ?>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/toll-analysis" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>


                        </div>
                    </div>
                </div>
            </div>

            <!-- Bakım ve Servis Raporları -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-tool me-2"></i>
                            <?php echo e(__("Maintenance and Service Reports")); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_inspection','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-lime text-white avatar">
                                                    <i class="ti ti-calendar-stats"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Maintenance Schedule")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Planned maintenance
                                                    reminders")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/inspection-schedule" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_vehicle_health','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-pink text-white avatar">
                                                    <i class="ti ti-car"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Vehicle Health Report")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Vehicle status and
                                                    performance")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/vehicle-health" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_mileage','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-dark text-white avatar">
                                                    <i class="ti ti-road"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Mileage Tracking")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Kilometer-based maintenance
                                                    check")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/mileage-tracking" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sürücü Performans Raporları -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-user-check me-2"></i>
                            <?php echo e(__("Driver Performance Reports")); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <?php if(\App\Helpers\PermissionHelper::hasPermission($cookieUserType ?? 999, $cookiePermissions ?? null, 'reports_driver_scoring','view')): ?>
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card card-link card-link-pop">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <span class="bg-azure text-white avatar">
                                                    <i class="ti ti-award"></i>
                                                </span>
                                            </div>
                                            <div class="col">
                                                <div class="font-weight-medium"><?php echo e(__("Driver Scoring")); ?></div>
                                                <div class="text-muted text-truncate"><?php echo e(__("Driving quality
                                                    assessment")); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <a href="/reports/driver-scoring" class="btn btn-sm btn-primary">
                                            <?php echo e(__("View Report")); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // Reports page functionality
    onAppReady(function () {
        // Initialize reports page
        showReportConfirmDialog();
    });

function showReportConfirmDialog() {

    let showAgain = localStorage.getItem("showReportConfirmDialog");
    //console.log(parseInt(showAgain), Date.now(), Date.now() < parseInt(showAgain));
    if (showAgain && Date.now() < parseInt(showAgain)) {
        return;
    }

    showConfirmDialog({
        title: __("Warning"),
        message: `
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                ${__(
                    "The speed and distance (km) data in these reports are based on GPS calculations. Due to factors like satellite signal quality, environmental conditions, and device positioning, slight deviations may occur. Therefore, the data should be considered approximate."
                )}
            </div>
            <div class="text-muted small">
                ${__(
                    "By proceeding, you acknowledge that the data shown in this report is approximate and may contain slight variations due to GPS accuracy limitations."
                )}
            </div>
        `,
        confirmText: __("Continue"),
        cancelText: __("I Understand") + ". " + __("Do not show again"),
        type: "warning",
        onConfirm: function () {
            // User acknowledged the warning
            localStorage.setItem("showReportConfirmDialog", 0);
        },
        onCancel: function () {
            let expiryMs = 24 * 60 * 60 * 1000; // 1 day
            let expiresAt = Date.now() + expiryMs;
            localStorage.setItem("showReportConfirmDialog", expiresAt);
        },
    });

}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\reports\index.blade.php ENDPATH**/ ?>