<div class="card-table table-responsive">
    <table class="table table-vcenter">
        <thead>
            <tr>
                <th><?php echo e(__("Region")); ?></th>
                <th><?php echo e(__("Price")); ?></th>
                <th><?php echo e(__("Status")); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($region["active"] == 1): ?>
            <tr>
                <td class="">
                    <?php echo e($region["name"]); ?>

                </td>
                <td style="width: 28%;">
                    <input type="number" name="region_price" class="form-control" step="1" min="0"
                        value="<?php echo e($region['price'] ?? ''); ?>" placeholder="0.00"
                        onchange="setRegionDevicePrice(<?php echo e($region['id']); ?>, this.value)">
                </td>
                <td>

                    <select name="region_status" class="form-select"
                        onchange="setRegionDeviceStatus(<?php echo e($region['id']); ?>, this.value)">
                        <option value="0" <?php echo e($region["match_status_id"]==0 ? 'selected' : ''); ?>>
                            <?php echo e(__("Alarm Off")); ?>

                        </option>
                        <option value="1" <?php echo e($region["match_status_id"]==1 ? 'selected' : ''); ?>>
                            <?php echo e(__("Can't Enter")); ?>

                        </option>
                        <option value="2" <?php echo e($region["match_status_id"]==2 ? 'selected' : ''); ?>>
                            <?php echo e(__("Can't Go Out")); ?>

                        </option>
                    </select>

                </td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<script>
    function setRegionDeviceStatus(regionId, status) {
        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            region_id: regionId,
            status: status
        });

        http.post({
            url: "/region-set-device",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "<?php echo e(__("Region status updated successfully")); ?>");
            } else {
                showNotification("error", "<?php echo e(__("Error updating region status")); ?> ");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "<?php echo e(__("Error updating region status")); ?>");
        });
    }

    function setRegionDevicePrice(regionId, price) {
        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            region_id: regionId,
            price: price
        });

        http.post({
            url: "/region-set-device-price",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "<?php echo e(__("Region price updated successfully")); ?>");
            } else {
                showNotification("error", "<?php echo e(__("Error updating region price")); ?>");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "<?php echo e(__("Error updating region price")); ?>");
        });
    }
</script><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\region.blade.php ENDPATH**/ ?>