<?php
$alarm_form_id = 304; // High Speed Alarm form ID
$high_speed = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($high_speed && isset($high_speed['settings_json']) && $high_speed['settings_json']){
if(is_string($high_speed['settings_json'])){
$j = json_decode($high_speed['settings_json'], true) ?: [];
} else {
$j = $high_speed['settings_json'];
}
}
?>

<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">

    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($high_speed['status_id']) && $high_speed['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                <?php echo e(__('Alarm Open')); ?>

            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($high_speed['status_id']) || !$high_speed['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                <?php echo e(__('Alarm Closed')); ?>

            </span>
        </label>
    </div>
    <div class="mb-3">
        <div class="row g-2">
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6"><?php echo e(__('Speed Limit')); ?></span>
                    <input type="number" name="speed_limit" min="0" class="form-control" autocomplete="off"
                        value="<?php echo e($j['speed_limit'] ?? ''); ?>" onchange="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                </div>
            </div>
        </div>
    </div>
</form>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/partials/forms/settings/high_speed.blade.php ENDPATH**/ ?>