<?php
$alarm_form_id = 303; // Towed alarm form ID
$towed = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($towed && isset($towed['settings_json']) && $towed['settings_json']){
if(is_string($towed['settings_json'])){
$j = json_decode($towed['settings_json'], true) ?: [];
} else {
$j = $towed['settings_json'];
}
}
?>
<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">
    <div class="mb-3">
        <?php echo e(__("This alarm may give false notifications in areas where the GPS signal is very weak.")); ?>

    </div>
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($towed['status_id']) && $towed['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                <?php echo e(__('Alarm Open')); ?>

            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($towed['status_id']) || !$towed['status_id'] ? 'checked' : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                <?php echo e(__('Alarm Closed')); ?>

            </span>
        </label>
    </div>
</form>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\towed.blade.php ENDPATH**/ ?>