

<?php $__env->startSection('title', __('User Management')); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xl">
    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="row g-2 align-items-center">
            <div class="col">
                <h2 class="page-title">
                    <i class="fas fa-users me-2"></i>
                    <?php echo e(__('User Management')); ?>

                </h2>
                <div class="text-muted mt-1"><?php echo e(__('Manage system users and their permissions')); ?></div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <!-- Users Table -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e(__('Users')); ?></h3>
            </div>
            <div class="card-body">
                <div id="usersTable"></div>
            </div>
        </div>
    </div>
</div>

<!-- Create User Modal -->
<div class="modal fade" id="createUserModal" tabindex="-1" aria-labelledby="createUserModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createUserModalLabel"><?php echo e(__('Create New User')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="createUserForm">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Name')); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="createName" name="nm" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Email')); ?> <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="createEmail" name="ml" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Password')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="createPassword" name="psw" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label"><?php echo e(__('Confirm Password')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="createPasswordConfirm"
                                    name="password_confirmation" required>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        <?php echo e(__('Create User')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit User Modal -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editUserModalLabel"><?php echo e(__('Edit User')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editUserForm">
                <input type="hidden" id="editUserId" name="user_id">
                <div class="modal-body">
                    <ul class="nav nav-tabs mb-3" id="editUserTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="edit-user-info-tab" data-bs-toggle="tab"
                                data-bs-target="#edit-user-info" type="button" role="tab" aria-controls="edit-user-info"
                                aria-selected="true"><?php echo e(__('User Info')); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link text-black px-6 bg-danger bg-opacity-25" id="edit-user-permissions-tab" data-bs-toggle="tab"
                                data-bs-target="#edit-user-permissions" type="button" role="tab"
                                aria-controls="edit-user-permissions" aria-selected="false"><?php echo e(__('Permissions')); ?></button>
                        </li>
                    </ul>
                    <div class="tab-content" id="editUserTabContent">
                        <div class="tab-pane fade show active" id="edit-user-info" role="tabpanel"
                            aria-labelledby="edit-user-info-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('Name')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="editName" name="nm" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('Email')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="editEmail" name="ml" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('New Password')); ?></label>
                                        <input type="password" class="form-control" id="editPassword" name="psw"
                                            placeholder="<?php echo e(__('Leave blank to keep current password')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                                        <input type="password" class="form-control" id="editPasswordConfirm"
                                            name="password_confirmation" placeholder="<?php echo e(__('Confirm new password')); ?>">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="edit-user-permissions" role="tabpanel"
                            aria-labelledby="edit-user-permissions-tab">
                            <div id="editPermissionsTableWrapper">
                                <div class="text-center text-muted py-4"><?php echo e(__('Loading permissions...')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        <?php echo e(__('Update User')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete User Modal -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteUserModalLabel"><?php echo e(__('Delete User')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(__('Are you sure you want to delete this user? This action cannot be undone.')); ?></p>
                <p class="text-muted" id="deleteUserName"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-danger" id="confirmDeleteUser">
                    <i class="fas fa-trash me-2"></i>
                    <?php echo e(__('Delete User')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .select2-container {
        z-index: 10000 !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    onAppReady(function() {
        // Initialize users table
        initializeUsersTable();
        
        // Form event listeners
        $('#createUserForm').on('submit', function(e) {
            e.preventDefault();
            createUser();
        });

        $('#editUserForm').on('submit', function(e) {
            e.preventDefault();
            updateUser();
        });
        
        $('#confirmDeleteUser').on('click', function() {
            deleteUser();
        });
    });

let usersTable = null;

function funcAddUser() {
    $('#createUserModal').modal('show');
}

function initializeUsersTable() {
    usersTable = createTabulator("#usersTable", {
        ajaxURL: "/api/users",
        ajaxResponse: function(url, params, response) {
            return response.data;
        },
        buttons: [
            {
                label: __('Add User'),
                icon: "fas fa-plus",
                icon_color: "success",
                func: funcAddUser,
            },
        ],
        columns: [
            {
                title: "<?php echo e(__('Member Type')); ?>",
                field: "member_type_name",
                formatter: function(cell) {
                    const value = cell.getValue();
                    return value ? __(value) : '';
                }
            },
            {
                title: "<?php echo e(__('Name')); ?>",
                field: "nm",
            },
            {
                title: "<?php echo e(__('Email')); ?>",
                field: "ml",
            },
            {
                title: "<?php echo e(__('Created')); ?>",
                field: "created_at",
                formatter: function(cell) {
                    const date = cell.getValue();
                    return date ? dateTimeFormatter(date) : '';
                }
            },
            {
                title: "<?php echo e(__('Updated')); ?>",
                field: "updated_at",
                formatter: function(cell) {
                    const date = cell.getValue();
                    return date ? dateTimeFormatter(date) : '';
                }
            },
            {
                title: "<?php echo e(__('Actions')); ?>",
                formatter: function(cell) {
                    const user = cell.getRow().getData();
                    return `
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-sm btn-outline-primary px-2 py-1" onclick="editUser(${user.id})">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-danger px-2 py-1" onclick="showDeleteUser(${user.id}, '${user.nm}')">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    `;
                },
                headerSort: false,
                width: 120
            }
        ]
    });
}

function createUser() {
    const formData = new FormData($('#createUserForm')[0]);
    const data = {
        nm: formData.get('nm'),
        email: formData.get('ml'),  // Send as 'email' for validation
        password: formData.get('psw')  // Send as 'password' for validation
    };
    
    // Validate password confirmation
    if (data.password !== formData.get('password_confirmation')) {
        showToast('error', '<?php echo e(__("Passwords do not match")); ?>');
        return;
    }
    

    
    http.post({
        url: '/api/users',
        data: data
    })
    .then(response => {
        if (response.success) {
            showToast('success', '<?php echo e(__("User created successfully")); ?>');
            $('#createUserForm')[0].reset();
            $('#createUserModal').modal('hide');
            usersTable.setData();
        } else {
            showToast('error', response.message || '<?php echo e(__("Error creating user")); ?>');
        }
    })
    .catch(error => {
        console.error('Error creating user:', error);
        showToast('error', '<?php echo e(__("Error creating user")); ?>');
    });
}

function editUser(userId) {
    http.get({
        url: `/api/users/${userId}`,
        loading: false
    })
    .then(response => {
        if (response.success) {
            const user = response.data;
            
            $('#editUserId').val(user.id);
            $('#editName').val(user.nm || '');
            $('#editEmail').val(user.ml || '');
            
            // Load user's direct permissions
            loadUserPermissions(userId);
            
            $('#editUserModal').modal('show');
            


        } else {
            showToast('error', response.message || '<?php echo e(__("Error loading user")); ?>');
        }
    })
    .catch(error => {
        console.error('Error loading user:', error);
        showToast('error', '<?php echo e(__("Error loading user")); ?>');
    });
}

function updateUser() {
    const formData = new FormData($('#editUserForm')[0]);
    const userId = $('#editUserId').val();
    const data = {
        nm: formData.get('nm'),
        email: formData.get('ml')  // Send as 'email' for validation
    };
    
    // Add password if provided
    if (formData.get('psw')) {
        if (formData.get('psw') !== formData.get('password_confirmation')) {
            showToast('error', '<?php echo e(__("Passwords do not match")); ?>');
            return;
        }
        data.password = formData.get('psw');  // Send as 'password' for validation
    }
    
    // Get selected permissions
    const permissions = {};
    $('.permission-checkbox').each(function() {
        const permissionKey = $(this).data('permission');
        const action = $(this).data('action');
        const isChecked = $(this).is(':checked');
        
        if (!permissions[permissionKey]) {
            permissions[permissionKey] = {};
        }
        permissions[permissionKey][action] = isChecked;
    });
    
    
    // Update user basic info first
    http.put({
        url: `/api/users/${userId}`,
        data: data
    })
    .then(response => {
        if (response.success) {
            // Then update permissions
            return http.put({
                url: `/api/users/${userId}/direct-permissions`,
                data: { permissions: permissions }
            });
        } else {
            throw new Error(response.message || '<?php echo e(__("Error updating user")); ?>');
        }
    })
    .then(permissionsResponse => {
        if (permissionsResponse.success) {
            showToast('success', '<?php echo e(__("User updated successfully")); ?>');
            $('#editUserModal').modal('hide');
            initializeUsersTable();
        } else {
            showToast('error', permissionsResponse.message || '<?php echo e(__("Error updating permissions")); ?>');
        }
    })
    .catch(error => {
        console.error('Error updating user:', error);
        showToast('error', error.message || '<?php echo e(__("Error updating user")); ?>');
    });
}

function showDeleteUser(userId, userName) {
    $('#deleteUserName').text(userName);
    $('#confirmDeleteUser').attr('data-user-id', userId);
    $('#deleteUserModal').modal('show');
}

function deleteUser() {
    const userId = $('#confirmDeleteUser').attr('data-user-id');
    
    http.delete({
        url: `/api/users/${userId}`,
    })
    .then(response => {
        if (response.success) {
            showToast('success', '<?php echo e(__("User deleted successfully")); ?>');
            $('#deleteUserModal').modal('hide');
            usersTable.setData();
        } else {
            showToast('error', response.message || '<?php echo e(__("Error deleting user")); ?>');
        }
    })
    .catch(error => {
        console.error('Error deleting user:', error);
        showToast('error', '<?php echo e(__("Error deleting user")); ?>');
    });
}

function loadUserPermissions(userId) {
    // First load available permissions
    http.get({
        url: '/api/users/permissions',
        loading: false
    })
    .then(permissionsResponse => {
        if (permissionsResponse.success) {
            const availablePermissions = permissionsResponse.data;
            
            // Then load user's current permissions
            http.get({
                url: `/api/users/${userId}/direct-permissions`,
                loading: false
            })
            .then(userPermissionsResponse => {
                if (userPermissionsResponse.success) {
                    const userPermissions = userPermissionsResponse.data;
                    renderPermissionsTable(availablePermissions, userPermissions);
                } else {
                    showToast('error', userPermissionsResponse.message || '<?php echo e(__("Error loading user permissions")); ?>');
                }
            })
            .catch(error => {
                console.error('Error loading user permissions:', error);
                showToast('error', '<?php echo e(__("Error loading user permissions")); ?>');
            });
        } else {
            showToast('error', permissionsResponse.message || '<?php echo e(__("Error loading permissions")); ?>');
        }
    })
    .catch(error => {
        console.error('Error loading permissions:', error);
        showToast('error', '<?php echo e(__("Error loading permissions")); ?>');
    });
}

function renderPermissionsTable(availablePermissions, userPermissions) {
    let tableHtml = `
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th><?php echo e(__('Module')); ?></th>
                        <th><?php echo e(__('Permission')); ?></th>
                        <th class="text-center"><?php echo e(__('Access')); ?></th>
                        <th class="text-center"><?php echo e(__('View')); ?></th>
                        <th class="text-center"><?php echo e(__('Edit')); ?></th>
                        <th class="text-center"><?php echo e(__('Delete')); ?></th>
                    </tr>
                </thead>
                <tbody>
    `;
    
    Object.keys(availablePermissions).forEach(moduleKey => {
        const module = availablePermissions[moduleKey];
        const permissions = module.permissions;
        
        Object.keys(permissions).forEach(permissionKey => {
            const permissionName = permissions[permissionKey];
            const userPermission = userPermissions[permissionKey] || {
                access: false,
                view: false,
                edit: false,
                delete: false
            };
            let showAccess = true;
            var moduleName = __(module.name);
            if((permissionKey.split('_').length - 1) > 0){
                moduleName = "";
                showAccess = false;
            }
            tableHtml += `
                <tr>
                    <td><strong>${moduleName}</strong></td>
                    <td>${__(permissionName)}</td>
                    <td class="text-center">
                        <input type="checkbox" class="form-check-input permission-checkbox ${showAccess ? '' : 'd-none'}" 
                               data-permission="${permissionKey}" data-action="access"
                               ${userPermission.access ? 'checked' : ''}>
                    </td>
                    <td class="text-center">
                        <input type="checkbox" class="form-check-input permission-checkbox" 
                               data-permission="${permissionKey}" data-action="view"
                               ${userPermission.view ? 'checked' : ''}>
                    </td>
                    <td class="text-center">
                        <input type="checkbox" class="form-check-input permission-checkbox" 
                               data-permission="${permissionKey}" data-action="edit"
                               ${userPermission.edit ? 'checked' : ''}>
                    </td>
                    <td class="text-center">
                        <input type="checkbox" class="form-check-input permission-checkbox" 
                               data-permission="${permissionKey}" data-action="delete"
                               ${userPermission.delete ? 'checked' : ''}>
                    </td>
                </tr>
            `;
        });
    });
    
    tableHtml += `
                </tbody>
            </table>
        </div>
    `;
    
    $('#editPermissionsTableWrapper').html(tableHtml);
}

function showToast(type, message) {
    showNotification(type, message);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/users.blade.php ENDPATH**/ ?>