<?php
    $cardClasses = ['card'];
    if ($class) {
        $cardClasses[] = $class;
    }
    $cardClass = implode(' ', $cardClasses);
    
    $uniqueId = $id ?: 'card-' . uniqid();
    $cardId = 'id="' . $uniqueId . '"';
    $cardDataAttributes = '';
    if ($collapsible) {
        $cardDataAttributes .= ' data-bs-toggle="collapse" data-bs-target="#' . $uniqueId . '-body"';
    }
?>

<div class="<?php echo e($cardClass); ?>" <?php echo e($cardId); ?><?php echo e($cardDataAttributes); ?>>
    <?php if($title || $subtitle || $header || $collapsible || $removable): ?>
        <div class="card-header">
            <?php if($header): ?>
                <?php echo $header; ?>

            <?php else: ?>
                <div class="d-flex w-100 align-items-center">
                    <div class="flex-fill">
                        <?php if($title): ?>
                            <h3 class="card-title"><?php echo e($title); ?></h3>
                        <?php endif; ?>
                        <?php if($subtitle): ?>
                            <div class="card-subtitle"><?php echo e($subtitle); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="card-actions ms-auto">
                        <?php if($collapsible): ?>
                            <button type="button" class="btn btn-action" data-bs-toggle="collapse" data-bs-target="#<?php echo e($uniqueId); ?>-body" id="<?php echo e($uniqueId); ?>-toggle">
                                <i class="ti ti-chevron-<?php echo e(($collapsed === true || $collapsed === 'true') ? 'down' : 'up'); ?>" id="<?php echo e($uniqueId); ?>-icon"></i>
                            </button>
                        <?php endif; ?>
                        <?php if($removable): ?>
                            <button type="button" class="btn btn-action" onclick="this.closest('.card').remove()">
                                <i class="ti ti-x"></i>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    
    <div class="card-body <?php echo e($collapsible ? 'collapse' : ''); ?> <?php echo e($collapsible && ($collapsed !== true && $collapsed !== 'true') ? 'show' : ''); ?>" id="<?php echo e($uniqueId); ?>-body">
        <?php echo e($slot); ?>

    </div>
    
    <?php if($footer): ?>
        <div class="card-footer">
            <?php echo $footer; ?>

        </div>
    <?php endif; ?>
</div>

<?php if($collapsible): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const toggleButton = document.getElementById('<?php echo e($uniqueId); ?>-toggle');
    const icon = document.getElementById('<?php echo e($uniqueId); ?>-icon');
    const targetBody = document.getElementById('<?php echo e($uniqueId); ?>-body');
    
    if (toggleButton && icon && targetBody) {
        // İlk durumu kontrol et ve icon'u ayarla
        const isCollapsed = !targetBody.classList.contains('show');
        icon.className = isCollapsed ? 'ti ti-chevron-down' : 'ti ti-chevron-up';
        
        // Bootstrap collapse event'lerini dinle
        targetBody.addEventListener('show.bs.collapse', function() {
            icon.className = 'ti ti-chevron-up';
        });
        
        targetBody.addEventListener('hide.bs.collapse', function() {
            icon.className = 'ti ti-chevron-down';
        });
    }
});
</script>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\components\card.blade.php ENDPATH**/ ?>