<?php $__env->startSection('title', __('CCTV Monitoring') ); ?>

<?php $__env->startSection('content'); ?>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <?php echo e(__('Surveillance')); ?>

                </div>
                <h2 class="page-title">
                    <?php echo e(__('CCTV Monitoring')); ?>

                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <button class="btn btn-primary" 
                            onclick="refreshAllFeeds()"
                            data-bs-toggle="popover" 
                            data-bs-trigger="hover" 
                            data-bs-placement="top" 
                            data-bs-content="<?php echo e(__('Refresh All Vehicle Feeds')); ?>">
                        <i class="ti ti-refresh"></i>
                        <?php echo e(__('Refresh')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Page body -->
<div class="page-body" id="cctv-page-body">
    <div class="container-xl">
        
        <!-- CCTV Controls Panel -->
        <div class="card mb-3">
            <div class="card-header">
                <h3 class="card-title"><?php echo e(__('CCTV Controls')); ?></h3>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <!-- Auto Refresh -->
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('Auto Refresh')); ?></label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="autoRefreshInterval" value="1" min="1" max="60" step="1">
                            <span class="input-group-text"><?php echo e(__('min')); ?></span>
                            
                            <button type="button" class="btn btn-outline-primary" 
                                    id="startAutoRefreshBtn" 
                                    onclick="startAutoRefresh()" 
                                    style="display: none;"
                                    data-bs-toggle="popover" 
                                    data-bs-trigger="hover" 
                                    data-bs-placement="top" 
                                    data-bs-content="<?php echo e(__('Start Auto Refresh')); ?>">
                                <i class="ti ti-player-play"></i> <?php echo e(__('Start')); ?>

                            </button>
                            <button type="button" class="btn btn-outline-danger" 
                                    id="stopAutoRefreshBtn" 
                                    onclick="stopAutoRefresh()"
                                    data-bs-toggle="popover" 
                                    data-bs-trigger="hover" 
                                    data-bs-placement="top" 
                                    data-bs-content="<?php echo e(__('Stop Auto Refresh')); ?>">
                                <i class="ti ti-player-stop"></i> <?php echo e(__('Stop')); ?>

                            </button>
                            <span class="input-group-text"> <span id="countdownTimer">--:--</span></span>
                        </div>
                    </div>
                    
                    <!-- Vehicle Status Filter -->
                    <div class="col-md-2">
                        <label class="form-label"><?php echo e(__('Vehicle Status')); ?></label>
                        <select class="form-select" id="vehicleStatusFilter" onchange="filterVehicles()">
                            <option value="all"><?php echo e(__('All Vehicles')); ?></option>
                            <option value="active"><?php echo e(__('Active Only')); ?></option>
                            <option value="moving"><?php echo e(__('Moving Vehicles')); ?></option>
                            <option value="stopped"><?php echo e(__('Stopped Vehicles')); ?></option>
                        </select>
                    </div>
                    
                    <!-- Vehicle Selection -->
                    <div class="col-md-3">
                        <label class="form-label"><?php echo e(__('Vehicle Selection')); ?></label>
                        <div class="input-group">
                            <select class="form-select" id="vehicleSelection" onchange="changeVehicleSelection()">
                                <option value="auto"><?php echo e(__('Auto (Smart Grid)')); ?></option>
                                <option value="first"><?php echo e(__('First 4 Vehicles')); ?></option>
                                <option value="first8"><?php echo e(__('First 8 Vehicles')); ?></option>
                                <option value="first12"><?php echo e(__('First 12 Vehicles')); ?></option>
                                <option value="first16"><?php echo e(__('First 16 Vehicles')); ?></option>
                                <option value="custom"><?php echo e(__('Custom Selection')); ?></option>
                            </select>
                            <button class="btn btn-outline-secondary" 
                                    type="button" 
                                    onclick="showVehicleSelector()"
                                    data-bs-toggle="popover" 
                                    data-bs-trigger="hover" 
                                    data-bs-placement="top" 
                                    data-bs-content="<?php echo e(__('Select Specific Vehicles')); ?>">
                                <i class="ti ti-list"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Pagination Controls -->
                    <div class="col-md-2" id="paginationControls" style="display: none;">
                        <label class="form-label"><?php echo e(__('Page')); ?></label>
                        <div class="input-group">
                            <button class="btn btn-outline-secondary" 
                                    type="button" 
                                    onclick="previousPage()"
                                    data-bs-toggle="popover" 
                                    data-bs-trigger="hover" 
                                    data-bs-placement="top" 
                                    data-bs-content="<?php echo e(__('Previous Page')); ?>">
                                <i class="ti ti-chevron-left"></i>
                            </button>
                            <input type="number" class="form-control text-center" id="currentPage" value="1" min="1" readonly>
                            <span class="input-group-text">/ <span id="totalPages">1</span></span>
                            <button class="btn btn-outline-secondary" 
                                    type="button" 
                                    onclick="nextPage()"
                                    data-bs-toggle="popover" 
                                    data-bs-trigger="hover" 
                                    data-bs-placement="top" 
                                    data-bs-content="<?php echo e(__('Next Page')); ?>">
                                <i class="ti ti-chevron-right"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Vehicle Count -->
                    <div class="col-md-2">
                        <label class="form-label"><?php echo e(__('Vehicle Count')); ?></label>
                        <div class="form-control-plaintext">
                            <span id="totalVehicles">0</span> <?php echo e(__('total')); ?> | 
                            <span id="activeVehicles">0</span> <?php echo e(__('active')); ?> | 
                            <span id="movingVehicles">0</span> <?php echo e(__('moving')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CCTV Grid Container -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><?php echo e(__('Live Feeds')); ?></h3>
                <div class="card-actions">
                    <button class="btn btn-outline-primary btn-sm" 
                            onclick="toggleFullscreen()"
                            data-bs-toggle="popover" 
                            data-bs-trigger="hover" 
                            data-bs-placement="top" 
                            data-bs-content="<?php echo e(__('Toggle Fullscreen Mode')); ?>">
                        <i class="ti ti-maximize"></i>
                        <?php echo e(__('Fullscreen')); ?>

                    </button>
                </div>
            </div>
            <div class="card-body p-0">
                <div id="cctv-grid" class="cctv-grid-container">
                    <!-- Grid will be dynamically generated here -->
                </div>
            </div>
        </div>

        <!-- Status Bar -->
        <div class="card mt-3">
            <div class="card-body py-2">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <small class="text-muted">
                            <i class="ti ti-clock"></i>
                            <?php echo e(__('Last Update')); ?>: <span id="lastUpdate">-</span>
                        </small>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">
                            <i class="ti ti-car"></i>
                            <?php echo e(__('Active Vehicles')); ?>: <span id="activeCameras">0</span>
                        </small>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">
                            <i class="ti ti-speed"></i>
                            <?php echo e(__('Moving Vehicles')); ?>: <span id="movingVehiclesCount">0</span>
                        </small>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">
                            <i class="ti ti-signal"></i>
                            <?php echo e(__('Connection')); ?>: <span id="connectionStatus" class="text-success"><?php echo e(__('Online')); ?></span>
                        </small>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Camera Detail Modal -->
<div class="modal modal-blur fade" id="cameraDetailModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Vehicle Detail')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="cameraDetailContent">
                    <!-- Camera detail content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                <button type="button" class="btn btn-primary" onclick="openVehicleDetail()"><?php echo e(__('View Vehicle Details')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Vehicle Selector Modal -->
<div class="modal modal-blur fade" id="vehicleSelectorModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Select Vehicles')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <div class="input-group">
                        <input type="text" class="form-control" id="vehicleSearch" placeholder="<?php echo e(__('Search vehicles...')); ?>">
                        <button class="btn btn-outline-secondary" type="button" onclick="clearVehicleSelection()">
                            <?php echo e(__('Clear All')); ?>

                        </button>
                        <button class="btn btn-outline-primary" type="button" onclick="selectAllVehicles()">
                            <?php echo e(__('Select All')); ?>

                        </button>
                    </div>
                    <small class="text-muted mt-2 d-block">
                        <?php echo e(__('Click on vehicles to select/deselect them. Selected vehicles will be shown in the grid.')); ?>

                    </small>
                </div>
                <div id="vehicleSelectorList" class="vehicle-selector-list">
                    <!-- Vehicle list will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-primary" onclick="applyVehicleSelection()"><?php echo e(__('Apply Selection')); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style> 
    .cctv-grid-container {
        min-height: 600px;
        background: #000;
        position: relative;
        overflow: hidden;
    }

    .cctv-grid {
        display: grid;
        gap: 2px;
        height: 100%;
        min-height: 600px;
        max-height: 80vh;
    }

    .cctv-grid-1x1 { grid-template-columns: 1fr; }
    .cctv-grid-2x2 { grid-template-columns: 1fr 1fr; grid-template-rows: 1fr 1fr; }
    .cctv-grid-3x3 { grid-template-columns: 1fr 1fr 1fr; grid-template-rows: 1fr 1fr 1fr; }
    .cctv-grid-4x4 { grid-template-columns: 1fr 1fr 1fr 1fr; grid-template-rows: 1fr 1fr 1fr 1fr; }
    .cctv-grid-2x3 { grid-template-columns: 1fr 1fr; grid-template-rows: 1fr 1fr 1fr; }
    .cctv-grid-3x2 { grid-template-columns: 1fr 1fr 1fr; grid-template-rows: 1fr 1fr; }

    /* Dynamic custom grid layouts */
    .cctv-grid-1x2 { grid-template-columns: 1fr 1fr; grid-template-rows: 1fr; }
    .cctv-grid-2x1 { grid-template-columns: 1fr; grid-template-rows: 1fr 1fr; }
    .cctv-grid-1x3 { grid-template-columns: 1fr 1fr 1fr; grid-template-rows: 1fr; }
    .cctv-grid-3x1 { grid-template-columns: 1fr; grid-template-rows: 1fr 1fr 1fr; }
    .cctv-grid-1x4 { grid-template-columns: 1fr 1fr 1fr 1fr; grid-template-rows: 1fr; }
    .cctv-grid-4x1 { grid-template-columns: 1fr; grid-template-rows: 1fr 1fr 1fr 1fr; }
    .cctv-grid-2x4 { grid-template-columns: 1fr 1fr; grid-template-rows: 1fr 1fr 1fr 1fr; }
    .cctv-grid-4x2 { grid-template-columns: 1fr 1fr 1fr 1fr; grid-template-rows: 1fr 1fr; }
    .cctv-grid-3x4 { grid-template-columns: 1fr 1fr 1fr; grid-template-rows: 1fr 1fr 1fr 1fr; }
    .cctv-grid-4x3 { grid-template-columns: 1fr 1fr 1fr 1fr; grid-template-rows: 1fr 1fr 1fr; }

    .cctv-feed {
        background: #1a1a1a;
        border: 1px solid #333;
        position: relative;
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .cctv-feed:hover {
        border-color: #007bff;
        box-shadow: 0 0 10px rgba(0, 123, 255, 0.3);
    }

    .cctv-feed.active {
        border-color: #28a745;
        box-shadow: 0 0 15px rgba(40, 167, 69, 0.5);
    }

    .cctv-feed-header {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        background: rgba(0, 0, 0, 0.8);
        color: white;
        padding: 5px 20px 5px 10px;
        font-size: 12px;
        z-index: 1000;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .cctv-feed-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0, 0, 0, 0.8);
        color: white;
        padding: 5px 10px;
        font-size: 11px;
        z-index: 1000;
    }

    .cctv-feed-map {
        width: 100%;
        height: 100%;
        min-height: 200px;
    }

    .cctv-feed-status {
        position: absolute;
        top: 9px;
        right: 5px;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        z-index: 1001;
    }

    .cctv-feed-status.online { background: #28a745; }
    .cctv-feed-status.offline { background: #dc3545; }
    .cctv-feed-status.recording { background: #dc3545; animation: blink 1s infinite; }

    @keyframes blink {
        0%, 50% { opacity: 1; }
        51%, 100% { opacity: 0.3; }
    }

    .cctv-feed-controls {
        position: absolute;
        top: 58px;
        left: 100px;
        transform: translate(-50%, -50%);
        background: rgba(0, 0, 0, 0.8);
        border-radius: 5px;
        padding: 10px;
        display: none;
        z-index: 1002;
    }

    .cctv-feed:hover .cctv-feed-controls {
        display: block;
    }

    .cctv-feed-controls .btn {
        margin: 2px;
        font-size: 12px;
        padding: 4px 8px;
    }

    .fullscreen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        z-index: 9999;
        background: #000;
    }

    .fullscreen .cctv-grid-container {
        height: 100vh;
    }

    .loading-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.7);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        z-index: 1003;
    }

    .no-feed {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100%;
        color: #666;
        font-style: italic;
    }

    .fullscreen-close-btn {
        position: absolute !important;
        top: 35px !important;
        right: 75px !important;
        z-index: 10000 !important;
        background: rgba(220, 53, 69, 0.9) !important;
        border: none !important;
        color: white !important;
        border-radius: 50% !important;
        width: 40px !important;
        height: 40px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        cursor: pointer !important;
        transition: all 0.3s ease !important;
    }

    .fullscreen-close-btn:hover {
        background: rgba(220, 53, 69, 1) !important;
        transform: scale(1.1) !important;
    }

    .leaflet-top {
    top: 25px;
    }

    .vehicle-selector-list {
        max-height: 400px;
        overflow-y: auto;
        border: 1px solid #dee2e6;
        border-radius: 0.375rem;
    }

    .vehicle-selector-item {
        display: flex;
        align-items: center;
        padding: 10px;
        border-bottom: 1px solid #f1f3f4;
        cursor: pointer;
        transition: background-color 0.2s;
    }

    .vehicle-selector-item:hover {
        background-color: #f8f9fa;
    }

    .vehicle-selector-item.selected {
        background-color: #e3f2fd;
        border-left: 3px solid #2196f3;
    }

    .vehicle-selector-item input[type="checkbox"] {
        margin-right: 10px;
    }

    .vehicle-selector-item .vehicle-info {
        flex: 1;
    }

    .vehicle-selector-item .vehicle-name {
        font-weight: 500;
        margin-bottom: 2px;
    }

    .vehicle-selector-item .vehicle-status {
        font-size: 12px;
        color: #6c757d;
    }

    .vehicle-selector-item .vehicle-status.online {
        color: #28a745;
    }

    .vehicle-selector-item .vehicle-status.offline {
        color: #dc3545;
    }

    .vehicle-selector-item .vehicle-status.moving {
        color: #007bff;
    }

    .vehicle-selector-item .vehicle-actions {
        margin-left: 10px;
    }

    /* Responsive grid for different screen sizes */
    @media (max-width: 1200px) {
        .cctv-grid-4x4 { grid-template-columns: 1fr 1fr 1fr; grid-template-rows: repeat(6, 1fr); }
    }

    @media (max-width: 768px) {
        .cctv-grid-4x4, .cctv-grid-3x3 { grid-template-columns: 1fr 1fr; grid-template-rows: repeat(8, 1fr); }
    }
    #countdownTimer {
    font-family: 'Courier New', monospace;
    font-size: 1.1em;
    color: var(--tblr-primary);
    background-color: var(--tblr-bg-surface);
    padding: 2px 6px;
    border-radius: 4px;
    border: 1px solid var(--tblr-border-color);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
// Global variables
let cctvData = [];
let autoRefreshInterval = null;
let selectedCameraId = null;

// Global variables for vehicle management
let currentPage = 1;
let vehiclesPerPage = 4;
let selectedVehicles = [];
let filteredVehicles = [];

// Countdown timer variables
let countdownInterval = null;
let nextRefreshTime = null;

    // Set up menu
    var menuModel = {
        actives : ["a_maps_li","a_map_vehicles-map-cctv"],
        shows: ["s_map_li_a","s_map_div"]
    };
    menuSets(menuModel);

// Initialize the page
onAppReady(function() {
    // Load initial data
    loadCCTVData();
    
    // Set up vehicle search
    $('#vehicleSearch').on('input', function() {
        loadVehicleSelectorList();
    });
    
    // Set up auto refresh interval
    const interval = parseInt($('#autoRefreshInterval').val()) || 1;
    if (interval > 0) {
        setupAutoRefresh(interval * 60000);
    }
    
    // Initialize popovers
    popoverInit();
    
    // Load translations
    //loadTranslations();
});



function loadCCTVData() {
    showLoading();
    
    http.post({
        loading: false,
        url: "api/vehicles/list",
    }).then((response) => {
        // Extract vehicles from the response
        cctvData = response.data.vehicles || [];

        //console.log(cctvData);
        
        // Initialize filtered vehicles
        filterCameraData(cctvData);
        renderCCTVGrid();
        updateStatusBar();
        hideLoading();
    }).catch((error) => {
        console.error("Error loading CCTV data:", error);
        hideLoading();
        showNotification("error", `Error loading camera feeds: ${error.message || 'Unknown error'}`);
    });
}

function renderCCTVGrid() {
    const gridContainer = $('#cctv-grid');
    const vehicleSelection = $('#vehicleSelection').val();
       
    // Get vehicles for current page
    let vehiclesToShow = [];
    
    if (vehicleSelection === 'custom' && selectedVehicles.length > 0) {
        // Show only selected vehicles
        vehiclesToShow = filteredVehicles.filter(v => selectedVehicles.includes(v.did));
    } else {
        // Show vehicles based on pagination
        const startIndex = (currentPage - 1) * vehiclesPerPage;
        vehiclesToShow = filteredVehicles.slice(startIndex, startIndex + vehiclesPerPage);
    }
    
    // Calculate optimal grid layout
    const optimalLayout = calculateOptimalLayout(vehiclesToShow.length);
    
    
    // Create grid structure
    let gridHTML = `<div class="cctv-grid cctv-grid-${optimalLayout}">`;
    
    // Create feed slots
    for (let i = 0; i < vehiclesToShow.length; i++) {
        const camera = vehiclesToShow[i];
        gridHTML += createCameraFeed(camera, i);
    }
    
    // Add empty slots if needed for grid layout
    const maxSlots = getMaxFeeds(optimalLayout);
    for (let i = vehiclesToShow.length; i < maxSlots; i++) {
        gridHTML += createEmptyFeed(i);
    }
    
    gridHTML += '</div>';
    gridContainer.html(gridHTML);
    
    // Initialize maps for each feed
    initializeCameraMaps();
    updatePagination();
    
    // Initialize popovers for the new buttons
    popoverInit();
}

function createCameraFeed(camera, index) {
    if (!camera) {
        return createEmptyFeed(index);
    }
    
    const status = getCameraStatus(camera);
    const isOnline = camera.latitude && camera.longitude && (camera.latitude * 1) > 0;
    const vehicleName = camera.device_data ? camera.device_data.nm : camera.name;
    
    return `
        <div class="cctv-feed" data-camera-id="${camera.did}" data-index="${index}">
            <div class="cctv-feed-status ${isOnline ? 'online' : 'offline'}"></div>
            <div class="cctv-feed-header">
                <span><i class="ti ti-camera"></i> ${vehicleName}</span>
                <span>${status}</span>
            </div>
            <div class="cctv-feed-map" id="cctv-map-${index}"></div>
            <div class="cctv-feed-overlay">
                <div><i class="ti ti-speed"></i> ${camera.speed || 0} km/h</div>
                <div><i class="ti ti-clock"></i> ${camera.timestamp_ui}</div>
            </div>
            <div class="cctv-feed-controls">
                <button class="btn btn-sm btn-primary" 
                        onclick="fullscreenFeed(${index})"
                        data-bs-toggle="popover" 
                        data-bs-trigger="hover" 
                        data-bs-placement="top" 
                        data-bs-content="<?php echo e(__('Fullscreen View')); ?>">
                    <i class="ti ti-maximize"></i>
                </button>
                <button class="btn btn-sm btn-info" 
                        onclick="showCameraDetail('${camera.did}')"
                        data-bs-toggle="popover" 
                        data-bs-trigger="hover" 
                        data-bs-placement="top" 
                        data-bs-content="<?php echo e(__('View Details')); ?>">
                    <i class="ti ti-info-circle"></i>
                </button>
            </div>
        </div>
    `;
}

function createEmptyFeed(index) {
    return `
        <div class="cctv-feed empty-feed" data-index="${index}">
            <div class="no-feed">
                <i class="ti ti-camera-off"></i>
                <span><?php echo e(__('No Vehicle')); ?></span>
            </div>
        </div>
    `;
}

function initializeCameraMaps() {
    // Get vehicles for current page
    let vehiclesToShow = [];
    const vehicleSelection = $('#vehicleSelection').val();
    
    if (vehicleSelection === 'custom' && selectedVehicles.length > 0) {
        // Show only selected vehicles
        vehiclesToShow = filteredVehicles.filter(v => selectedVehicles.includes(v.did));
    } else {
        // Show vehicles based on pagination
        const startIndex = (currentPage - 1) * vehiclesPerPage;
        vehiclesToShow = filteredVehicles.slice(startIndex, startIndex + vehiclesPerPage);
    }
    
    vehiclesToShow.forEach((camera, index) => {
        if (camera.latitude && camera.longitude && (camera.latitude * 1) > 0) {
            createCameraMap(index, camera);
        }
    });
}

function createCameraMap(index, camera) {
    const mapId = `cctv-map-${index}`;
    const mapContainer = document.getElementById(mapId);
    
    if (!mapContainer) return;
    
    // Better map cleanup
    if (mapContainer._leaflet_id) {
        try {
            // Properly remove the map instance if it exists
            if (window[`map_${mapId}`] && window[`map_${mapId}`].map) {
                window[`map_${mapId}`].map.remove();
            }
        } catch (e) {
            console.warn('Error cleaning up map:', e);
        }
        mapContainer._leaflet_id = null;
    }
    
    // Create new map
    let myMap = new LeafletMap();
    myMap.initMap(mapId, {
        zoomLevelDefault: 15,
        enableControls: false
    });
    
    // Store map reference for cleanup
    window[`map_${mapId}`] = myMap;
    
    // Add marker
    const marker = {
        id: `camera-${camera.did}`,
        popup: createCameraPopup(camera),
        coord: [(camera.latitude * 1), (camera.longitude * 1)],
        icon: {
            name: camera.direction != null ? "fa-solid fa-location-arrow" : "fa-solid fa-car",
            color: camera.status_color ? camera.status_color : "blue",
            direction: camera.direction != null ? Number(camera.direction) : 0,
            className: "Camera",
        },
        handler: {
            status: camera.status_name,
            group: camera.device_data ? camera.device_data.cats : [],
            did: camera.did,
        }
    };
    
    myMap.pinMarkers([marker]);
}

function createCameraPopup(camera) {
    const speed = Number(camera.speed * 1).toFixed(2) + " km/h";
    const direction = Number(camera.direction * 1).toFixed(0) + "°";
    const vehicleName = camera.device_data ? camera.device_data.nm : camera.name;
    
    return `
        <div class="camera-popup">
            <h6><i class="ti ti-camera"></i> ${vehicleName}</h6>
            <div><i class="ti ti-speed"></i> ${speed}</div>
            <div><i class="ti ti-compass"></i> ${direction}</div>
            <div><i class="ti ti-clock"></i> ${camera.timestamp_ui}</div>
            <div><i class="ti ti-road"></i> ${__(camera.status_name)}</div>
            <button class="btn btn-sm btn-primary mt-2" onclick="showCameraDetail('${camera.did}')">
                ${__('View Details')}
            </button>
        </div>
    `;
}

function getCameraStatus(camera) {
    if (!camera || !camera.latitude || !camera.longitude || (camera.latitude * 1) <= 0) {
        return __('Offline');
    }
    
    // Use the status_name from the new data model if available
    if (camera.status_name) {
        return __(camera.status_name);
    }
    
    // Fallback to speed-based status
    if (camera.speed > 0) {
        return __('Moving');
    } else {
        return __('Stopped');
    }
}

function filterCameraData(data) {
    const filter = $('#vehicleStatusFilter').val();
    
    switch (filter) {
        case 'active':
            filteredVehicles = data.filter(camera => camera.latitude && camera.longitude && (camera.latitude * 1) > 0);
            break;
        case 'moving':
            filteredVehicles = data.filter(camera => camera.speed > 0);
            break;
        case 'stopped':
            filteredVehicles = data.filter(camera => camera.speed === 0 || !camera.speed);
            break;
        default:
            filteredVehicles = data;
    }
    
    return filteredVehicles;
}

function getMaxFeeds(layout) {
    if (layout === 'auto') {
        // Auto mode: show all available vehicles
        return cctvData.length;
    }
    
    const [rows, cols] = layout.split('x').map(Number);
    return rows * cols;
}

function startAutoRefresh() {
    const interval = parseInt($('#autoRefreshInterval').val()) || 1;
    
    // Add validation
    if (interval < 1 || interval > 60) {
        showNotification("error", "Auto refresh interval must be between 1 and 60 minutes");
        return;
    }
    
    setupAutoRefresh(interval * 60000); // Convert minutes to milliseconds
    
    // Hide Start button, show Stop button
    $('#startAutoRefreshBtn').hide();
    $('#stopAutoRefreshBtn').show();
    
    showNotification("success", `Auto refresh started (${interval} min)`);
}

function stopAutoRefresh() {
    if (autoRefreshInterval) {
        clearInterval(autoRefreshInterval);
        autoRefreshInterval = null;
        
        // Hide Stop button, show Start button
        $('#stopAutoRefreshBtn').hide();
        $('#startAutoRefreshBtn').show();
        
        showNotification("info", "Auto refresh stopped");
    }
    
    // Stop countdown
    stopCountdown();
}

function setupAutoRefresh(interval = 60000) {
    if (autoRefreshInterval) {
        clearInterval(autoRefreshInterval);
    }
    
    // Set next refresh time
    nextRefreshTime = new Date(Date.now() + interval);
    
    // Start countdown
    startCountdown();
    
    autoRefreshInterval = setInterval(() => {
        loadCCTVData();
        // Reset countdown after refresh
        nextRefreshTime = new Date(Date.now() + interval);
    }, interval);
}

function startCountdown() {
    // Clear existing countdown
    if (countdownInterval) {
        clearInterval(countdownInterval);
    }
    
    // Update countdown every second
    countdownInterval = setInterval(() => {
        updateCountdown();
    }, 1000);
    
    // Initial update
    updateCountdown();
}

function stopCountdown() {
    if (countdownInterval) {
        clearInterval(countdownInterval);
        countdownInterval = null;
    }
    $('#countdownTimer').text('--:--');
}

function updateCountdown() {
    if (!nextRefreshTime) {
        $('#countdownTimer').text('--:--');
        return;
    }
    
    const now = new Date();
    const timeLeft = nextRefreshTime - now;
    
    if (timeLeft <= 0) {
        $('#countdownTimer').text('00:00');
        return;
    }
    
    // Convert to minutes and seconds
    const minutes = Math.floor(timeLeft / 60000);
    const seconds = Math.floor((timeLeft % 60000) / 1000);
    
    // Format as MM:SS
    const formattedTime = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
    $('#countdownTimer').text(formattedTime);
}

function refreshAllFeeds() {
    loadCCTVData();
}

function updateStatusBar() {
    const totalVehicles = cctvData.length;
    const activeVehicles = cctvData.filter(camera => camera.latitude && camera.longitude && (camera.latitude * 1) > 0).length;
    const movingVehicles = cctvData.filter(camera => camera.speed > 0).length;
    
    $('#totalVehicles').text(totalVehicles);
    $('#activeVehicles').text(activeVehicles);
    $('#movingVehicles').text(movingVehicles);
    $('#activeCameras').text(activeVehicles);
    $('#movingVehiclesCount').text(movingVehicles);
    $('#lastUpdate').text(dateTimeFormatter(new Date()));
}

function toggleFullscreen() {
    const container = $('#cctv-grid').parent();
    const isFullscreen = container.hasClass('fullscreen');
    
    if (!isFullscreen) {
        // Enter fullscreen
        container.addClass('fullscreen');
        $('body').css('overflow', 'hidden');
        // Add close button
        if (!$('.fullscreen-close-btn').length) {
            container.append('<button class="btn btn-danger fullscreen-close-btn" onclick="exitAllFullscreen()"><i class="ti ti-x"></i></button>');
        }
        // Refresh maps after fullscreen
        setTimeout(() => {
            initializeCameraMaps();
            popoverInit();
        }, 100);
    } else {
        // Exit fullscreen
        exitAllFullscreen();
    }
}

function exitAllFullscreen() {
    const container = $('#cctv-grid').parent();
    
    // Always remove fullscreen class and reset state
    container.removeClass('fullscreen');
    $('body').css('overflow', 'auto');
    $('.fullscreen-close-btn').remove();
    
    // Refresh maps after exiting fullscreen
    setTimeout(() => {
        initializeCameraMaps();
        popoverInit();
    }, 100);
    
    
}

function fullscreenFeed(index) {
    const feed = $(`.cctv-feed[data-index="${index}"]`);
    const isFullscreen = feed.hasClass('fullscreen');
    
    if (!isFullscreen) {
        // Enter feed fullscreen
        feed.addClass('fullscreen');
        $('body').css('overflow', 'hidden');
        // Add close button for individual feed
        if (!feed.find('.fullscreen-close-btn').length) {
            feed.append('<button class="btn btn-danger fullscreen-close-btn" onclick="exitFeedFullscreenMode(' + index + ')"><i class="ti ti-x"></i></button>');
        }
        // Refresh the specific map
        setTimeout(() => {
            const camera = cctvData.find(c => c.did == feed.data('camera-id'));
            if (camera) {
                createCameraMap(index, camera);
            }
            popoverInit();
        }, 100);
    } else {
        // Exit feed fullscreen
        exitFeedFullscreenMode(index);
    }
}

function exitFeedFullscreenMode(index) {
    const feed = $(`.cctv-feed[data-index="${index}"]`);
    
    // Always remove fullscreen class and reset state
    feed.removeClass('fullscreen');
    $('body').css('overflow', 'auto');
    feed.find('.fullscreen-close-btn').remove();
    
    // Refresh the specific map
    setTimeout(() => {
        const camera = cctvData.find(c => c.did == feed.data('camera-id'));
        if (camera) {
            createCameraMap(index, camera);
        }
        popoverInit();
    }, 100);
    
    
}

function showCameraDetail(cameraId) {
    selectedCameraId = cameraId;
    const camera = cctvData.find(c => c.did == cameraId);
    
    if (!camera) {
        showNotification("error", "Camera not found");
        return;
    }
    
    const vehicleName = camera.device_data ? camera.device_data.nm : camera.name;
    const plateNumber = camera.device_data ? camera.device_data.plt : camera.plate_number;
    const driverName = camera.device_data ? camera.device_data.drvr : camera.driver_name;
    
    const detailContent = `
        <div class="row">
            <div class="col-md-8">
                <div id="detail-map" style="height: 400px;"></div>
            </div>
            <div class="col-md-4">
                <h5>${vehicleName}</h5>
                <table class="table table-sm">
                    <tr><td>${__('Status')}:</td><td>${__(camera.status_name)}</td></tr>
                    <tr><td>${__('Speed')}:</td><td>${camera.speed || 0} km/h</td></tr>
                    <tr><td>${__('Direction')}:</td><td>${camera.direction || 0}°</td></tr>
                    <tr><td>${__('Plate Number')}:</td><td>${plateNumber || '-'}</td></tr>
                    <tr><td>${__('Driver')}:</td><td>${driverName || '-'}</td></tr>
                    <tr><td>${__('Last Update')}:</td><td>${camera.timestamp_ui}</td></tr>
                    <tr><td>${__('Location')}:</td><td>${camera.latitude}, ${camera.longitude}</td></tr>
                </table>
            </div>
        </div>
    `;
    
    $('#cameraDetailContent').html(detailContent);
    $('#cameraDetailModal').modal('show');
    
    // Initialize detail map after modal is shown (use one-time event)
    $('#cameraDetailModal').one('shown.bs.modal', function() {
        setTimeout(() => {
            createDetailMap(camera);
        }, 200);
    });
}

function createDetailMap(camera) {
    const mapContainer = document.getElementById('detail-map');
    if (!mapContainer) return;
    
    // Clear existing map completely
    if (mapContainer._leaflet_id) {
        try {
            // Remove the map instance
            if (window.detailMap && window.detailMap.map) {
                window.detailMap.map.remove();
                window.detailMap = null;
            }
        } catch (e) {
            console.warn('Error cleaning up detail map:', e);
        }
        mapContainer._leaflet_id = null;
    }
    
    // Clear the container
    mapContainer.innerHTML = '';
    
    // Create new map
    let myMap = new LeafletMap();
    myMap.initMap('detail-map', {
        zoomLevelDefault: 15
    });
    
    // Store map reference
    window.detailMap = myMap;
    
    const marker = {
        id: `detail-${camera.did}`,
        popup: createCameraPopup(camera),
        coord: [(camera.latitude * 1), (camera.longitude * 1)],
        icon: {
            name: "fa-solid fa-location-arrow",
            color: "red",
            direction: camera.direction != null ? Number(camera.direction) : 0,
            className: "DetailCamera",
        }
    };
    
    myMap.pinMarkers([marker]);
    
    // Force map refresh
    setTimeout(() => {
        if (window.detailMap && window.detailMap.map) {
            window.detailMap.map.invalidateSize();
        }
    }, 100);
}

function openVehicleDetail() {
    if (!selectedCameraId) return;
    
    var vehicle = cctvData.find(c => c.did == selectedCameraId);
    if (!vehicle) return;
    
    const urlModel = {
        did: selectedCameraId,
        date: vehicle.timestamp.split(" ")[0], 
        start_time: "00:00",
        end_time: "23:59"
    };

    const encodedUrl = Base64Helper.encode(urlModel);
    window.location.href = `/vehicle-map/${encodedUrl}`;
}

function showLoading() {
    $('#cctv-grid').append('<div class="loading-overlay"><i class="ti ti-loader ti-spin"></i> <?php echo e(__('Loading...')); ?></div>');
}

function hideLoading() {
    $('.loading-overlay').remove();
}

// Handle page visibility changes
document.addEventListener('visibilitychange', function() {
    if (document.hidden) {
        // Page is hidden, pause auto refresh and countdown
        if (autoRefreshInterval) {
            clearInterval(autoRefreshInterval);
            autoRefreshInterval = null;
        }
        if (countdownInterval) {
            clearInterval(countdownInterval);
            countdownInterval = null;
        }
    } else {
        // Page is visible, resume auto refresh if it was running
        if (autoRefreshInterval === null && nextRefreshTime) {
            const timeLeft = nextRefreshTime - new Date();
            if (timeLeft > 0) {
                const interval = parseInt($('#autoRefreshInterval').val()) || 1;
                setupAutoRefresh(interval * 60000);
            }
        }
    }
});

// Handle window resize
$(window).resize(function() {
    // Reinitialize maps on resize
    setTimeout(() => {
        initializeCameraMaps();
        popoverInit();
    }, 100);
});

function filterVehicles() {
    // Re-filter the data when status filter changes
    filterCameraData(cctvData);
    currentPage = 1; // Reset to first page
    renderCCTVGrid();
}

function changeVehicleSelection() {
    const selection = $('#vehicleSelection').val();
    
    switch (selection) {
        case 'auto':
            vehiclesPerPage = calculateOptimalGridSize();
            $('#paginationControls').show();
            selectedVehicles = []; // Clear custom selection
            break;
        case 'first':
            vehiclesPerPage = 4;
            $('#paginationControls').hide();
            selectedVehicles = []; // Clear custom selection
            break;
        case 'first8':
            vehiclesPerPage = 8;
            $('#paginationControls').hide();
            selectedVehicles = []; // Clear custom selection
            break;
        case 'first12':
            vehiclesPerPage = 12;
            $('#paginationControls').hide();
            selectedVehicles = []; // Clear custom selection
            break;
        case 'first16':
            vehiclesPerPage = 16;
            $('#paginationControls').hide();
            selectedVehicles = []; // Clear custom selection
            break;
        case 'custom':
            showVehicleSelector();
            return;
    }
    
    currentPage = 1;
    renderCCTVGrid();
    updatePagination();
}

function calculateOptimalGridSize() {
    const totalVehicles = filteredVehicles.length;
    
    if (totalVehicles <= 4) return 4;
    if (totalVehicles <= 9) return 9;
    if (totalVehicles <= 16) return 16;
    if (totalVehicles <= 25) return 25;
    if (totalVehicles <= 36) return 36;
    if (totalVehicles <= 49) return 49;
    if (totalVehicles <= 64) return 64;
    if (totalVehicles <= 81) return 81;
    return 100; // Max 100 vehicles
}

function showVehicleSelector() {
    loadVehicleSelectorList();
    $('#vehicleSelectorModal').modal('show');
}

function loadVehicleSelectorList() {
    const searchTerm = $('#vehicleSearch').val().toLowerCase();
    const listContainer = $('#vehicleSelectorList');
    let html = '';
       
    // Add summary at the top
    if (selectedVehicles.length > 0) {
        html += `
            <div class="alert alert-info mb-3">
                <i class="ti ti-check"></i> 
                ${selectedVehicles.length} <?php echo e(__('vehicle(s) selected')); ?>

                <button class="btn btn-sm btn-outline-secondary float-end" onclick="clearVehicleSelection()">
                    <?php echo e(__('Clear All')); ?>

                </button>
            </div>
        `;
    }
    
    filteredVehicles.forEach(vehicle => {
        const vehicleName = vehicle.device_data ? vehicle.device_data.nm : vehicle.name;
        const isVisible = vehicleName.toLowerCase().includes(searchTerm);
        const isSelected = selectedVehicles.includes(vehicle.did);
        
        if (isVisible) {
            const status = getCameraStatus(vehicle);
            const statusClass = status === 'Offline' ? 'offline' : (status === 'Moving' ? 'moving' : 'online');
            
            html += `
                <div class="vehicle-selector-item ${isSelected ? 'selected' : ''}" onclick="toggleVehicleSelection('${vehicle.did}')">
                    <input type="checkbox" ${isSelected ? 'checked' : ''} onclick="toggleVehicleSelection('${vehicle.did}'); event.stopPropagation();">
                    <div class="vehicle-info">
                        <div class="vehicle-name">${vehicleName}</div>
                        <div class="vehicle-status ${statusClass}">${status} - ${vehicle.speed || 0} km/h</div>
                    </div>
                    <div class="vehicle-actions">
                        <button class="btn btn-sm btn-outline-primary" onclick="event.stopPropagation(); showCameraDetail('${vehicle.did}')">
                            <i class="ti ti-eye"></i>
                        </button>
                    </div>
                </div>
            `;
        }
    });
    
    listContainer.html(html);
    
}

function toggleVehicleSelection(vehicleId) {
        
    const index = selectedVehicles.indexOf(vehicleId);
    if (index > -1) {
        selectedVehicles.splice(index, 1);
    } else {
        selectedVehicles.push(vehicleId);
    }
    
    loadVehicleSelectorList();
}

function selectAllVehicles() {
    selectedVehicles = filteredVehicles.map(v => v.did);
    loadVehicleSelectorList();
}

function clearVehicleSelection() {
    selectedVehicles = [];
    loadVehicleSelectorList();
}

function applyVehicleSelection() {
       
    if (selectedVehicles.length === 0) {
        showNotification("warning", "Please select at least one vehicle");
        return;
    }
    
    vehiclesPerPage = selectedVehicles.length;
    currentPage = 1;
    $('#vehicleSelectorModal').modal('hide');
    $('#paginationControls').hide();
    
    // Set the dropdown to custom to show the selected vehicles
    $('#vehicleSelection').val('custom');
    
    // Force re-render
    renderCCTVGrid();
    
    
}

function previousPage() {
    if (currentPage > 1) {
        currentPage--;
        $('#currentPage').val(currentPage);
        renderCCTVGrid();
    }
}

function nextPage() {
    const totalPages = Math.ceil(filteredVehicles.length / vehiclesPerPage);
    if (currentPage < totalPages) {
        currentPage++;
        $('#currentPage').val(currentPage);
        renderCCTVGrid();
    }
}

function updatePagination() {
    const totalPages = Math.ceil(filteredVehicles.length / vehiclesPerPage);
    $('#totalPages').text(totalPages);
    $('#currentPage').val(currentPage);
    
    if (totalPages <= 1) {
        $('#paginationControls').hide();
    } else {
        $('#paginationControls').show();
    }
}

function calculateOptimalLayout(vehicleCount) {
    if (vehicleCount <= 1) return '1x1';
    if (vehicleCount <= 2) return '1x2';
    if (vehicleCount <= 4) return '2x2';
    if (vehicleCount <= 6) return '2x3';
    if (vehicleCount <= 9) return '3x3';
    if (vehicleCount <= 12) return '3x4';
    if (vehicleCount <= 16) return '4x4';
    if (vehicleCount <= 20) return '4x5';
    if (vehicleCount <= 25) return '5x5';
    if (vehicleCount <= 30) return '5x6';
    if (vehicleCount <= 36) return '6x6';
    if (vehicleCount <= 42) return '6x7';
    if (vehicleCount <= 49) return '7x7';
    if (vehicleCount <= 56) return '7x8';
    if (vehicleCount <= 64) return '8x8';
    if (vehicleCount <= 72) return '8x9';
    if (vehicleCount <= 81) return '9x9';
    if (vehicleCount <= 90) return '9x10';
    return '10x10'; // Max 100 vehicles
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/vehicles-map-cctv.blade.php ENDPATH**/ ?>